from SystemEntity import SystemEntity
from Link import Link
import csv
from Node import Node
from OverlayNode import OverlayNode
import logging
import random
from numpy.random import randint
logger = logging.getLogger(__name__)
import numpy as np
import Config


class Network():
    def __init__(self):
        self.nodes = {}#{1 : Node(1),2:Node(2)}
        self.links = {} #{(1,2):Link(1-2),(2,1):Link(2,1),(3,2):Link(3*2)}      linkID = tuple(1,2)
        self.networkClockTime = 0
        self.pk_weight_map = {}
        self.time = 0

    def setupNetwork(self):
        '''
        Assumption : nodes are unique
                    links are unique and bidirectional
                    no errorneous nodes present in the file
                    no erroneous link present in the file
                    self loops are not there

        Adds links and nodes to the network .It is a one time activity.

        :return:
        '''
        w = randint(1, 51, Config.NUMBER_OF_NODES_IN_NETWORK) # 51 is excluded - range (1,50)
        self.badaW = np.sum(w)
        i = 0
        with open('Nodes1.dat', 'r') as f:
            reader = csv.reader(f)
            for row in reader:
                node = row[0] # Node id
                xnode = {node:OverlayNode(node,self,w[i])}
                self.pk_weight_map.update({xnode[node].pk:w[i]})
                self.nodes.update(xnode)#added node to network
                # print(self.nodes.get('1')) #keys are strings


        with open('Links1.dat', 'r') as f:
            reader = csv.reader(f)
            for row in reader:
                tup = row[0].split()
                link = None  # tuple of a link
                if int(tup[0]) < int(tup[1]):
                    link = (tup[0],tup[1])
                else:
                    link = (tup[1],tup[0])

                linkDelay = 1
                self.links.update({link:Link(link,self,linkDelay)})

                # adding adjacent nodes list to each node
                self.nodes.get(link[0]).adjacentNodes.append(link[1])
                self.nodes.get(link[1]).adjacentNodes.append(link[0])
                # print(self.links.get(('1', '2'))) #keys are strings


        pass

    def getLink(self,tup):
        if int(tup[0]) < int(tup[1]) :
            return self.links.get(tup)
        else:
            return self.links.get((tup[1],tup[0]))

    def simulate(self,time):
        self.time = time
        # logger.info("simulating .. ")
        self.networkClockTime = time
        # Note links should be simulated before nodeself.ResumeTasks.append(("nextOn", self.startNodeLifeCycleGenerator,))s
        #  in order to receive the messge which is supposed to be received in this tick
        for link in self.links.values():
            link.simulate(time)

        for node in self.nodes.values():
            node.simulate(time)

        pass

if __name__ == '__main__':
    network = Network()
    network.setupNetwork()

    pass
