from SystemEntity import SystemEntity
from Node import Node
import logging



class Link(SystemEntity):
    def __init__(self,link,network,linkDelay):
        '''
        :param link: (1,2)
        :param network:
        :param linkDelay: delay of a link


        '''
        SystemEntity.__init__(self,network)
        self.logger = logging.getLogger(__name__ + "-" + str(link))

        self.upNode = link[0]
        self.downNode = link[1]
        self.link = link
        self.messageQueue = []
        self.linkDelay = linkDelay

        '''
        contains string command and its corresponding method to be executed
        useful to execute task from todolist
        '''
        self.commands = {"delieverMessage": self.delieverMessage,
                         }

        pass

    def delieverMessage(self,time,params):
        '''

        :param time:
        :param params: [ whomtodeliever , payload ]
        :return:
        '''
        node = self.network.nodes.get(params[0])
        node.enqueMessage((time, params[1]))
        pass

    def enqueMessage(self,message):
        '''

        :param message: (timestamp , payload)    --- timestamp is the tick value at which node has inserted this message in queue
        payload #1 : ('NOde1', 'Node2', 'Content of message')
        payload #2 :

        :return:
        '''
        self.messageQueue.append(message)
        # print("message enqued")

    def dequeMessage(self):
        return self.messageQueue.pop(0)

    def scheduleMessageDelievery(self,time,payload):
        task = ("delieverMessage",payload[1],payload)  #(command,whomtodeliever,what to deliever)
        scheduledTime = str(int(time) + self.linkDelay)
        self.todoList[scheduledTime].append(task)



    def simulate(self,time):
        # self.logger.info("simulating .. ")

        '''
        Process message first then process task in todo-list
        because messages in the link are placed in last tick 
        and the processing of those messages may create some tasks for current tick
        
        all messages will be proceessed i.e., at the end of each tick simulation links will not have 
        any unprocessed message the receive buffer or message-queue 
        
        '''
        #todo process messages in queue
            # generate tasks for todolist based on messges
        for message in self.messageQueue:
            self.scheduleMessageDelievery(message[0],message[1])

        # TODO : perform task from todolist which are relevant for current tick

        try:
            tasks = self.todoList.pop(time)
            for task in tasks:
                command = self.commands.get(task[0])
                command(time,task[1:])
        except KeyError as ke:
            # not task pending at this time
            pass



if __name__ == '__main__':
    x = {(1,2):"1*2",
         (2,1):"2*1",
         (3,2):"3*2"}

    print(x.get((2,1,3)))

