---
layout: post
title: Epilogues
tags: [lit]
---

One thing to note before you start reading this: I haven't written anything in a
long time. I'm just gonna ramble.  Note 2: I started writing this before
*Echoes* and some of the stuff meant to be here ended up there, so not much
rambling! :)

I just finished watching *American Reunion*. I loved it. I watched *Men In
Black<sup>3</sup>*, and I loved that too. You know why? Because once I get
started on a tale, I want to know how it ends. Not necessarily the complete
ending, with everyone dying off, but an ending that gives closure. I always
wondered what became of J after he let Laura go. I always wondered how K was in
his younger days. I love to know the history of a tale's universe, it's
back-story, as it's sometimes called. MiB<sup>3</sup> gave me that and a fitting
end, a nice little joke about chance. Similarly for *American Reunion*. Jim and
Michelle getting married, Oz not even in the picture, Finch doing his usual
thing... No, no: That's not how that tale would end. There always has to be an
epilogue. An epilogue gives us closure. A bit of what happened later, to tie up
all the loose threads. These movies were exactly that: Epilogues to a much-loved
tale long told. Maybe that's why I am not too excited about *Grown Ups 2: Grown
Ups* was an epilogue to a tale never told - but maybe it can be the prologue to
a tale yet to be told. Dragging on a film series like they have done with *Saw*
- that is an abomination, a sin.

Maybe the epilogue of *War and Peace* affected me a bit too strongly: It was the
first epilogue that I read so labelled. The earlier novels I read, *Wuthering
Heights* and *Jane Eyre* had similar chapters too, short, but satisfying. *War
and Peace*, on the other hand, had an epilogue befitting its length. It
contained a lot of interesting thoughts. The passage on how the French
Revolution happened was one of the funniest passages I have read, and since
then, I have had a bit of reluctance in studying our world's history, absurd as
it is - why should any other world's history be any less important? That is why,
to me, the *Lord of the Rings* is the greatest tale I have read. The appendices
provide some more information about that world, and the Chronology tells me how
it ends for each member of the Fellowship. The death of Aragorn, followed by the
departure of Legolas for Valinor (accompanied by Gimli, so it has been told)
concluded that tale for me. Contrast this with *Rita Hayworth and the Shawshank
Redemption*, which most of you will know better as the movie *The Shawshank
Redemption*. Its final lines are so written that the overwhelming sense of
uncertainty filled with hope would be thoroughly destroyed by an epilogue. That
is why I regard *The Shawshank Redemption* as the greatest film ever made: It
transcended the book it adapted. It's ending, and the movie in general somehow
managed to be as good as, if not better than, the novella. Few, if any,
adaptations manage that. Most fumble at it - like a teenager fumbling at a bra
strap. Some mess it up completely - like Jim with Nadia. *The Shawshank
Redemption* redeemed them all.

But when it comes to tales that demand epilogues, I think the standard to beat
is set by *Foundation and Earth* and *Rama Revealed*. Both books are just that -
a conclusion to a long tale. Both have fitting titles. Rama is revealed -
somewhat. Earth and Foundation - the two ends of the Galaxy - the beginning and
the end. To end a tale that spanned around 22,000 years, three separate series
and 16 or so books in all would take a masterpiece - and Asimov, the master that
he is, did it oh so well. And the sly devil managed to slip in a few threads to
continue the tale, too. Reading that novel as the ship entered the Solar System
is one of the defining moments of my life. Meeting Daneel Olivaw there, I
realised why inevitably most people are theists. Seeing Daneel there, I felt all
the emotions people feel on seeing an old friend. Most importantly, since I
hadn't read the prequel books, I wasn't sure I'd meet him - a successor perhaps,
but not Daneel himself. But to know Daneel was present all along, guiding,
helping humanity - that was a relief. We really are too stupid to live long, you
know.


But let us leave these depressing thoughts. The prequel books to *Foundation* -
aha! Just as most tales leave me wanting to know how it all ends, most also
instil a desire to learn how it all began. Reading *Forward the Foundation* and
*Prelude to the Foundation* brought home how delightful a well-written prequel
truly is. It lends context the entire series,explaining details that otherwise
never really stood on their own. The *Silmarillion* was the other great prequel
I read. It's not really a prequel, since it was a separate book, taking place
Ages before The *Lord of the Rings*. Reading The *Silmarillion* was like reading
ancient history, and the discrepancies between it and the tales told in
*Unfinished Tales* and *The History of Middle Earth* books made it seem all the
more like real history, as if these were events that really happened, but with
no trustworthy and complete records. It was fascinating. Many people can't
comprehend how I can reread a novel or a series of novels from the start - don't
I already know what's going to happen? I do, in a general way. However, there
are several tiny details which attain greater significance in the context of
what happens later on. These details are like an "Aha!" moment, not quite
Eureka! but a flash of recognition when you realise that the Towers of Midnight
are mentioned as early as in book two of *The Wheel of Time* - *The Great Hunt*,
and all those dreams that Egwene has in book three foretelling events well in to
the tail-end of the series. It's quite fun, actually, re-reading those books. I
wonder what *A Memory of Light* will be like... Will it have a great epilogue?
Will it give closure? Or will it be like *Inheritance* and make you wonder when
the next part's releasing? :/
