---
layout: post
title: Arch on Alienware
tags: [tech, linux]
---

It's been [4½ years since I bought my System76 laptop][sys76], and it is showing its
age. Back in 2013, an NVIDIA GT670 MX was a pretty decent laptop graphics card
(which meant it couldn't hold a candle to the desktop graphics cards). But I was
able to play *Hitman: Absolution*, the various *Mass Effect* games, *Tomb
Raider* and so on on it, and with OK graphics levels and resolutions. Fast
forward to 2017, and we have *HITMAN*, *Mass Effect: Andromeda*, *Assassin's
Creed: Origins*, and the 670MX really struggled with them (I don't have
*Origins*, but it struggled with *Unity*). And so I decided to upgrade. After
casting my net far and wide, I decided against going for a laptop again. My
current laptop is functioning pretty much as a desktop[^1], so I might as well
get another desktop.

This time around, I decided to go for the best graphics card I could sanely get
(so, no Titan). That's the [1080 Ti][ars-1080] at the moment, with 11 GB of
GDDR5 graphics memory! I considered System76 once again, which did have models
supporting the 1080Ti. But … Dell had a discount going on the Alienware Aurora
R7 ([Ars Technica review][ars] of the 2016 model). After considering the
discount, shipping charges and support options (Dell had a good discount going
on accidental and on-site support coverage as well), Dell was proving to be
cheaper, and I finally opted for it. Ordered, shipped and received in 2 weeks!

Specs:

- Intel® Core™ i7 8700 (6 core/12 threads, 12 MB cache, 4.6 GHz max)
- NVIDIA® GeForce® GTX 1080 Ti 11GB GDDR5X
- 256GB M.2 PCIe Toshiba SSD
- 2TB 7200RPM SATA 6Gb/s Seagate HDD
- 16 GB dual-channel DDR4 @ 2666 Mhz (2x 8 GB)
- A Blu-ray reader/writer[^2]
- 7 USB 3.0-A ports (3 in front, 4 back)[^3]
- 5 USB 2.0-A ports (all in the back)
- 2 USB 3.0-C ports (one each front and back)
- 1 HDMI port and 4 DisplayPorts
- Killer 1535 802.11ac 2x2 WiFi & Bluetooth 4.1
- 850 W PSU, liquid-cooled chassis
- 14 kgs![^4]

It came with Windows 10 Pro, and setting it up was pleasant. Logged in with my
Microsoft account synced my theme and wallpapers (a nice touch). Set about
installing Steam, other software I commonly use on Windows, and, of course, WSL.
Installed *HITMAN*, cranked up the settings to Ultra at 1080p, and ran the
benchmark to get an average of ~59 FPS! That's head and shoulders above whatever
the 670MX could do at low-mid graphics. (The min was 4 FPS, but that came from a
stutter right at the very beginning). Even discounting the FPS values, the
benchmark looked smooth and clear in a way it never did on my laptop. Installed
*Assassin's Creed: Unity* - no problems with that one either.

Of course, my setting up didn't end there. The main quest was yet to be done:
installing Linux.

<!-- section -->

## Setting up Arch Linux

I must admit I had my worries about how well this thing would run Linux. The
network card name (Killer?!) didn't particularly inspire confidence, and that's
where most problems occur in a Linux setup - the LAN, WiFi and Bluetooth. And you
don't often to get hear about people running Linux with a 1080Ti. But if my
experience with the 670MX meant anything, graphics wouldn't be too much of a
problem.

### UEFI

Booting with a USB drive with Arch on it didn't prove troublesome. Both the
usual methods (use Windows' advanced reboot option to get to UEFI, and pressing
<kbd>Esc</kbd> during boot) worked and got me into the UEFI boot menu. As an
aside, the Alienware boot splash is a nicely understated logo that I really
liked. Couldn't find an image that looked just like it, so I took a photo of it
and processed it a bit to get this:

![][boot]

But that's probably the best bit about the Alienware UEFI setup. The UEFI menu
itself is … disappointing. It didn't support widescreen monitors, and I have
seen a few UEFI systems that do, so there's that. Many UEFI systems also support
screenshots, but this one doesn't.

I needed to disable Secure Boot to get Arch to boot, as expected. Disabling
Secure Boot enabled legacy boot as well, and the legacy boot splash is somewhat
crappy. I didn't want legacy boot, so I disabled that.

Once I selected the USB disk, Arch booted up right quick.

<!-- section -->

### Partitioning

I'd shrunk the partitions that already existed, to split the ~200 GB Windows
partition on the SSD in half, and to carve out a 500 GB space on the 2 TB disk.
There used to be a time when I thought more partitions were a good thing, and
I'd keep my data neatly divided into separate partitions (games on one, videos
on another, etc.). When I last upgraded my laptop, adding a 1 TB disk to (in
addition to the 500 GB it came with and the 500 GB disk from my older laptop),
my partition layout looked like this:

```
~ lsblk -o NAME,SIZE,FSTYPE,TYPE,MOUNTPOINT
NAME          SIZE FSTYPE            TYPE  LABEL       MOUNTPOINT
sda         931.5G                   disk
├─sda1       49.2G ntfs              part  Windows8
├─sda2        804M ntfs              part
├─sda3        500G ntfs              part  Downloads   /home/muru/Downloads
└─sda4      381.5G ntfs              part  Stuff       /home/muru/Stuff
sdb         465.8G linux_raid_member disk  ica-ext:0
└─md127     931.5G                   raid0
  ├─md127p1    40G ext4              md    arch        /
  ├─md127p2   100G ext4              md    devel       /home/muru/dev
  ├─md127p3   300G ext4              md    var         /home/muru/var
  ├─md127p4 483.5G ext4              md    archives    /home/muru/archives
  └─md127p5     8G swap              md                [SWAP]
sdc         465.8G linux_raid_member disk  ica-ext:0
└─md127     931.5G                   raid0
  ├─md127p1    40G ext4              md    arch        /
  ├─md127p2   100G ext4              md    devel       /home/muru/dev
  ├─md127p3   300G ext4              md    var         /home/muru/var
  ├─md127p4 483.5G ext4              md    archives    /home/muru/archives
  └─md127p5     8G swap              md                [SWAP]
```

In hindsight, that is just … insane. All those partitions meant that I soon ran
out of space in some of them. And of course, naïve as I was, I only granted
~50GB to Windows. This time around, I eschewed all that:

```
~ lsblk -o NAME,SIZE,FSTYPE,TYPE,LABEL,MOUNTPOINT /dev/sda /dev/nvme0n1
NAME          SIZE FSTYPE TYPE LABEL       MOUNTPOINT
sda           1.8T        disk
├─sda1        128M        part
├─sda2        1.3T ntfs   part Downloads   /home/muru/Downloads
└─sda3        500G ext4   part dev         /home/muru/dev
nvme0n1     238.5G        disk
├─nvme0n1p1   500M vfat   part ESP         /boot
├─nvme0n1p2   128M        part
├─nvme0n1p3 124.5G ntfs   part OS
├─nvme0n1p4   450M ntfs   part WINRETOOLS
├─nvme0n1p5  11.9G ntfs   part Image
├─nvme0n1p6     1G ntfs   part DELLSUPPORT
└─nvme0n1p7   100G ext4   part arch        /
```

Aside from the partitions already present, I added just two. Not even a swap
partition. Another upgrade I'd done to my laptop was to add 16 GB RAM to it,
for a total of 24 GB. And since then, I noted that swap was never used and I
don't think I have seen it use more than 16 GB RAM. Even if I need swap, I'll
probably use a swap file. No hibernation for me.

<!-- section -->

### Installing

After mounting, I realized that I'd forgotten to check the part that I'd worried
most about: the network. And to my pleasant surprise, *both* LAN and WiFi were
working perfectly fine OOTB:

```
# lspci | grep -i net
05:00.0 Network controller: Qualcomm Atheros QCA6174 802.11ac Wireless Network Adapter (rev 32)
06:00.0 Ethernet controller: Qualcomm Atheros Killer E2500 Gigabit Ethernet Controller (rev 10)
```

I'd never heard of "Killer" network cards before, and I didn't look them up
before I ordered, figuring I'd work something out if the card turned out to be
poorly supported. But nah, we've plain old Qualcomm Atheros here.

It was a simple matter of:

```
mount /dev/nvme0n1p7 /mnt
mkdir -p /mnt/boot/EFI
mount /dev/nvme0n1p1 /mnt/boot/EFI
pacstrap /mnt base base-devel gnome
```
And the usual steps in [the Installation Guide][guide]. (I'd accidentally
mounted the Windows partition instead of the Linux one on `/mnt`, but `pacstrap`
is non-destructive, so no harm done).

One thing I intended to  do this time was to skip GRUB and boot directly from
UEFI. This is possible because the Linux kernel from Arch has [EFISTUB]. While
using `efibootmgr` to set this up, I realized that the ESP was best mounted on
`/boot`, since the only thing `/boot` contained was the kernel image and the
initramfs, both of which had to be copied to the ESP anyway. So, remounting
`/mnt/boot`, and using these:

```
kernel_params="root=UUID=e5018f7e-5838-4a47-b146-fc1614673356 rw initrd=/initramfs-linux.img"
efibootmgr --disk /dev/nvme0n1 --part 1 --create --gpt --label "Arch Linux" --loader /vmlinuz-linux.efi --unicode "$kernel_params"
```

I got a new UEFI boot entry created and set as default automatically. The
command is long-winded enough that I saved it to file in root's home directory,
which turned out to be pretty handy later.

Next step was to edit `/etc/mkinitcpio.d/linux` to get it to create the
initramfs files in the locations listed above directly (using [the mkinitcpio(2)
method from the Arch Wiki][hook]).

Timezone set, `fstab` created,  hostname set … and reboot!

<!-- section -->

### Borking

Bork. Rebooting didn't work, it looks like I messed up the boot entry. I'd
missed the part where the paths were supposed to be rooted at the ESP partition.
So, rebooting back to the USB, chrooting again, and:
```
kernel_params="root=UUID=e5018f7e-5838-4a47-b146-fc1614673356 rw initrd=/EFI/arch/initramfs-linux.img"
efibootmgr --disk /dev/nvme0n1 --part 1 --create --gpt --label "Arch Linux" --loader /EFI/arch/vmlinuz-linux.efi --unicode "$kernel_params"
```

Reboot again, and I'm dropped into a TTY. :disappointed: I had installed `gnome`
after all. Of course, I forgot that Arch doesn't automatically enable services,
so logging in, and `systemctl enabla --now gdm` later,
I had … GDM crashing in a loop. I had both my TV and my monitor connected, so I
tried disconnecting my TV, which stabilized GNOME and allowed me to login.
Turns out GDM itself runs in Wayland, and while Wayland didn't have problems on
a running on a single screen, a dual display setup caused it to crash.

So, getting it to [use Xorg][xorg] instead:

```
sed -i '/WaylandEnable=false/s/^#//' /etc/gdm/custom.conf
```
And GDM worked fine with dual displays from then on.

Logging in, my next point of trouble: no networking! :sob: Panicked, I checked
`ip a` and `lspci` to realise that the devices were detected fine, but I'd
forgotten to install NetworkManager. A quick run of `dhcpd` later, I had
network.

### Steam

After that, it was relatively simple to install the other software that I usually
use, and setup a LAN cross-connection to my laptop to start copying files (I
used `tar c | nc`/`nc -l | tar x` for speed). I ran into some trouble getting
Steam to start, turned out to be missing 32-bit libraries:

```
libXtst.so.6
libXrandr.so.2
libgobject-2.0.so.0
libglib-2.0.so.0
libgio-2.0.so.0
libgtk-x11-2.0.so.0
libpulse.so.0
libgdk_pixbuf-2.0.so.0
```

Later on, `vdui2.so` couldn't be loaded. Then curl wasn't loaded.

All told, I needed to install:

```
# xargs -L1 -a ~muru/dev/steam-libs pkgfile -s | grep multi
multilib/lib32-libxtst
multilib/lib32-libxrandr
multilib/lib32-glib2
multilib/lib32-glib2
multilib/lib32-glib2
multilib/lib32-gtk2
multilib/lib32-libpulse
multilib/lib32-gdk-pixbuf2
# And
lib32-openal
lib32-curl
```

`steam-native` still refuses to start, but `steam-runtime` works well enough.

And finally:

![Imgur](https://i.imgur.com/QmHeTwb.jpg)

54 FPS! A 10% drop compared to Windows, but still pretty good for a port.
My gaming will no longer be as frustrating as it was before. :sunglasses:
:neckbeard:

<!-- section -->

Who knew an Alienware would be so comfortable for Linux? Besides goof-ups I made
because I hadn't installed Arch in ages and didn't pay attention to the Wiki, it
was a pretty easy install. It would have been easier still if I'd gone for
Ubuntu, I suspect. A far cry from some of the laptops I have installed Linux on
for friends, maybe the year of the Linux desktop is indeed at hand.

<!-- section -->

[^1]: Not because of battery issues, but because I burnt(!) the LVDS cable
      connecting the graphics card to the monitor. I will getting around to
      replacing that cable any day now.


[^2]: Never going to use it, probably.

[^3]: Some of these may be 3.1, because one of the USB controllers is an "ASMedia
      Technology Inc. ASM1142 USB 3.1" controller.

[^4]: My laptop is 4.5kgs. Looks like my computers all turn out to be
      heavyweights.

[ars]: https://arstechnica.com/gadgets/2016/10/alienware-aurora-review-gaming-pc/
[ars-1080]: https://arstechnica.com/gadgets/2017/03/nvidia-gtx-1080-ti-review/
[sys76]: {% post_url 2013-04-12-bonobo %}
[boot]: https://i.imgur.com/hCPyDT1.png
[guide]: https://wiki.archlinux.org/index.php/Installation_guide
[EFISTUB]: https://wiki.archlinux.org/index.php/EFISTUB#Using_UEFI_directly
[hook]: https://wiki.archlinux.org/index.php/EFI_System_Partition#Using_mkinitcpio_hook_.282.29
[xorg]: https://wiki.archlinux.org/index.php/GDM#Use_Xorg_backend
