---
title: The Character of God
layout: post
tags: [life, lit]
---

Over time, I have changed my position regarding the existence of god(s). From
*apathy* ('Don't know, don't care'), to *disbelief* (atheism) to *doubt*
(agnosticism). I have heard many accounts of god(s), from the 'universe, then
god' (like the ancient Greeks') to 'god, then universe' (most other accounts),
from single god (Christianity, Judaism, Islam) to many gods (Hinduism, the
Egyptian pantheon). The problem exists, in my opinion, specifically in the proof
(or lack thereof) of the existence of gods. For the purposes of this article,
let us consider a few things as given:

- The Universe (and everything in it) exists for a reason: the principle of
  causality
- If god(s) exist(s), said god(s) created the Universe. Also, since the Universe
  was created, whoever created it can be labelled 'god' (If a group created it,
  let's call the group 'god' and avoid the problem of the plural). Ergo god
  exists in any case.
- The Universe, and everything in and of it, is finite. (This is controversial,
  let us postpone discussion on it for a while.)

The first principle is essential, as it is the very basis of all of today's
science.  I believe that some of the primary purposes of science are to
establish the *causes* (*why*s of things), along with means (*how*s) and
predictions (*what now*s). The questions that are central to science is how and
why the Universe was created in the first place, but whether it lies within the
scope of science to assign a cause and means to its creation is beyond me.
The only way we can sidestep the problem of creation is by assigning a present
age of infinity to the Universe. That, of course, would be somewhat the trivial
solution for this question, and not possible because of the third condition.

Proof of existence of god is impossible within the framework of the Universe.
Consider the  two mutually exclusive situations in which god does interfere with
the Universe after creation, and does not. In the first case, it would be
impossible to assign an observable cause to acts of god, but simply because we
cannot observe the cause doesn't imply that the cause is god. The reason might
simply be beyond our present science. Unless we acquire infinite and complete
knowledge, which is clearly impossible, we cannot assign causes (or lack
thereof) to all events, again under the third condition. (As a side note: an
infinite and complete knowledge would also imply knowledge of creation of the
universe, thus solving that problem.) If god does not interfere with the
Universe after creation, then, of course, we cannot prove the existence of god
from phenomena within this Universe. So we can merely speculate and argue about
it.
:smile:

Now, given that god created the Universe, that still doesn't complete the cause.
There still exists the problem of why said god(s) created it. Most religions
don't give a damn about this, insofar as I can infer. They neither say anything
about it, nor say why they don't say anything. Science fiction authors, on
the other hand, do often speculate about it. From "The Lord is the name of my
cat." to the ultimate scientist, there have been many instances. Here I come to
the central point of my article. The thing is, "god(s)" present a theory, a
theory as to why the Universe exists and is the way it is. To completely ignore
said theory and disregard it is unscientific (ergo *atheism* is unscientific). My
favourite hypothesis is the one by Arthur C. Clarke in his *Rama* series. In it,
at the very end, he describes god as the ultimate scientist, who tries different
initial values to the problem of the Universe so as to obtain an Universe in
perfect harmony. Now lets avoid why the god wants perfect harmony (c'mon, do we
need to go into an infinite chain of reasons?), and what harmony means. The
thing is, this god has the best (for me) attribute of all. The god has a reason,
and has reason too, apparently.

The most interesting thing about this god, is that it apparently is subject to
one of the most fundamental principles of quantum theory: that we cannot
observe something without interfering with it. The observations are kept to a
minimum, and care is taken to minimise its effects. As far as I am concerned,
this concept totally beats Clarke's *Space Odysseys* and Asimov's Gaia/Galaxia
concept. But, not, I suppose, Douglas Adam's nuttiness.

Till later!
