---
layout: post
title: Moving to Arch
tags: [tech, config]
---

I'm not sure why, but Ubuntu takes a hell of a long time to start. The best I
could get was 59s - and on occasion it even went to 1:15! If you think this
isn't a cause for concern, this might tell you why it is.

I did the usual `bootchart` analysis, disabling Plymouth splash, tried profiling
via GRUB, disabling services... the usual. All to no avail, though. Booting
within a minute is okay, I suppose, but I know for sure 12.04 and down would
boot much faster on my old laptop.  I looked around, an in most places I noticed
something interesting - LightDM usually only waited for less than a second for
signals from X, in my case it was usually 15s or more. But I didn't have a
ConsoleKit problem, the XOrg was actually reading something. I tried switching
DMs - SLiM and lxdm - but no luck. 

Now that I am fiddling with my setup anyway, I decided to install Arch. This was
my third try, actually - neither of my previous two attempts while in IITG
succeeded. But third time lucky, eh? I went about installing Arch via both the
official and unofficial installation guides.

Since my aim was as fast a start as I could get while still looking good, I
decided to use btrfs for the root filesystem. We'll see how that goes. The
installation was mostly pain-free. Except at one point where the Arch Wiki tells
us to execute some commands and *then* shows a notice telling us to do so only
after rebooting, not within the chroot jail. That fucked up my wireless
connection, and I couldn't bring it back up. Luckily I had made the boot image,
and I had no intention of installing GRUB again, considering that I already had
one from Ubuntu. So I rebooted and got Ubuntu's GRUB to update itself, and then
booted into Arch - took it about 12s to get to the login prompt.

From there on, things were pretty easy. The hard part was deciding:

- Which DE should I use? GNOME? XFCE? Or not use a DE at all?
- Which file manager? Nemo? Nautilus?
- Which DM? LightDM? LXDM? SLiM?

Some things were eliminated straight off: I wouldn't use KDE or LXDE - I dislike
the feel of KDE and LXDE wasn't feature-rich enough. XFCE was a good bet, but it
was already my main setup on Ubuntu, and I wanted to try something new. I'd
always heard good things about Enlightenment, Ratpoison, WMII and other such
window managers, and I decided I didn't need a DE after all - I'd try
Enlightenment and get it to work.

As for file managers, I liked Nautilus and Nemo best, but I don't like the
direction the GNOME3 team are headed with that, just liked I didn't like it when
the made GDM a dependency of GNOME Shell or when they removed file listings the
search results of the Activities overview. I had stuck with GNOME Shell even
then, but the GDM dependency was the straw that broke the camel's back.
Seriously, how difficult can it be to understand that I don't want to drag up an
extra screen to enter my password? Take what you will from Metro, but *that* is
the worst part.

Again, last time I tried, I'd used E16 and was severely chastised. This time,
E17 proved to be a pleasure to use - its own basic file manager (a file manager
without tab support is always basic to me), excellent visual effects, okay
themes. SLiM posed some problems - it wouldn't start correctly on occasion, each
time I had to switch to Enlightenment even though it was my default - otherwise
it would log me in and leave me without anything to work with - problems with
stopping SLiM (each shutdown would take a couple of minutes, waiting for SLiM to
stop). So I ditched it and went with LXDM - but this time, I set up autologin,
so I don't even see the login screen. GRUB to desktop - within 30s!

Odd thing, though. E17 favours Connman to manage network connections, and try as
I would, I couldn't get `connman` to connect to my wireless network. Abandon
that and stick to Arch's default `netctl`. Though the lack of a GUI for `netctl`
is disconcerting.

I had no trouble setting up the nVidia drivers or my fingerprint scanner or the
touchpad. But it seems the ACPI keys will have to wait, since the Arch Wiki
tells me I'll have to manually set up actions matching the signal they emit. And
I have to set up other things - Bluetooth, for example.
