---
layout: post
title: A Lost Identity
tags: [life]
---

In my days at IITG, I have often been asked where I hail from. Somehow, I never
am sure how to answer it. Consider: I was born in Kerala, I stay in a town
called Kalyan, in Maharashtra, and am studying here in Guwahati, Assam. Should I
say, I am from Kalyan, where I stay, and which no one will recognise, or should
I say I am from Bombay (or Mumbai), which people will recognise? Or should I say
that I am from Kerala, where I was, in fact, born? Each answer means different
things, and I would often be in a quandary as to which meaning I should choose. 

The problem gets worse and worse. I am a Malayali, and my name is borrowed from
Tamil (my grandma's remark when my mum came up with the name). My name confuses
people when they hear that I'm from Bombay. Here at IITG, they instantly assume
that I am an Andhra, lo! even more confusion. And I have to set about explaining
things.

And let's not forget religious tendencies. I was born a Hindu (strangely enough,
I have also been mistaken for a Christian), became an atheist by choice and am
an agnostic by practice. That last phrase would be confusing: An atheist and an
agnostic are mutually exclusive terms. Let me make it clear: I have a problem
accepting god(s) as gods usually are represented: omnipresent, omniscient and
omnipotent. Now, I cannot accept any concept of a god with attributes that I
myself may not have, I cannot accept a superior being. But god(s) as sort-of
kick-starter(s) to the universe (as in Arthur C. Clarke's *Rama Revealed*) is(are)
certainly ok, so long as said god(s) refrain from interfering with the universe.

I know four languages: English (which I consider my first language, since I
think in it), Malayalam (my mother tongue), Hindi and Marathi. Now, I rarely get
to speak English, and it's more than a trifle rusty. My Malayalam vocabulary is
limited, and dying from disuse. My Hindi grammar is barbarous (to say the
least), and my Marathi is one-way. So which language should I speak in? English
and Malayalam have rarely found use, and my Marathi only allows me to listen,
but not to speak. And my Hindi would be offensive to the highest degree to any
purist.

Caught between identities is one thing, but caught between interests is another.
I am studying Mechanical Engineering at IITG, but my heart is anywhere but in
Mechanics. I love Mathematics, Physics, English, and Computer Science; I have a
strong leaning towards History, Philosophy, and even Psychology, but I have no
interest in the number crunching that Mechanics involve. And so, here I am,
faring well in Math and Physics (till last semester) and programming, but
verging towards the brink of failure in Solid and Fluid Mechanics as well as
Thermodynamics.

And then comes the primary passion in my life: reading books. People immediately
deduce, incorrectly, I'm afraid, that I am studious. I'm merely a bookworm, and
study only for the sake of the pleasure the knowledge brings me. Ergo, my dismal
grades in every major exam that I have taken.

Bombay, that is VT (Victoria Terminus, now named Chhatrapati Shivaji Terminus)
the main railway station, the heart of Bombay, is 50 km from my house. Though,
of course, to anyone who lives within the reach of the local trains, the world
is divided into two main regions: the one with Bombay's local trains, and the
one without (got the pun?).  Within the local train system, differences occur;
but without, whichever town or suburb you live in, you're from Bombay.

I recently finished reading Suketu Mehta's *Maximum City: Bombay Lost and Found*.
He remarks that Bombay is a city of exiles, of restless people, of people in
transit. That's how I see myself, as someone in transit, caught in a world to
which I do not belong, neither here nor there. But with a difference: Mehta's
people are in transit from one place to another, from one life to another, from
one level of power to another. I'm in transit, but in time, and my destinations
are æons apart. I long to be in those times of discovery and exploration, when
frontiers of the world, the sciences and mathematics were expanded rapidly, with
much to learn, and much more to discover, as it still is today in the abstract
fields. But now, to even reach those levels they discovered and explored, one
must spend a lifetime, either acquiring money for travel, or studying for
discovery and invention. In this era of increasing specialization, what chance
does someone like me have, who longs to be of the old breed, when scientists
were polymaths?

But what does my language, my name, my place of residence and my interests
matter? All my life, I have watched and envied people who were part of a group,
of a ‘crowd', a circle of friends. I have never been part of one, and I doubt I
will ever be. I wander from one group to another, using my friends in each group
as an entry point, but never lingering long enough to become a part. I have
always felt an envelope of loneliness about me: separating me from all others,
never letting me truly open my heart out and pour my thoughts and desires to
anyone, not even to my closest friends, not even the one time I had a
girlfriend, except the most superficial ones. To compensate, I populate my mind
with versions of people I meet, people I become interested in. I try to get to
know them as well as I can, and then carry on conversations, discussions and
debates with the mental version. Not one hour goes by in which I have not had a
talk with one of my mental creations. It gets so that I am absolutely lethargic
when it comes to calling my family or my friends.

You might think, how rightly I cannot say, that I am nuts. Please, understand
me, it is not so. I try discussing things with people, but each only
understands, or cares to understand only small fragments of my thoughts. To many
should I confide? To how many should I explain my philosophy? No, it is better
that my mind talk to itself, it is not a closed lake, but an ocean into which
streams and rivers are constantly pouring in new experiences, new thoughts and
new concepts. An analytic and imaginative brain like my own cannot afford
idleness, and I must have my companions, real or imaginary.

That is all I can say for today. It took me a lot of will power and
determination to get this all out, all of which I have, at one time or the
other, as one point or another, tried to discuss with my friends. If they
remember those occasions, I hope they'll understand better.

May be I am as Rhett Butler said to Scarlet O'Hara in Alexandra Ripley's
*Scarlet: The Sequel to Margaret Mitchell's Gone With The Wind*.

> "You belong with me, Scarlett, haven't you figured that out? And the world is
> where we belong, all of it. We're not home-and-hearth people. We're the
> adventurers, the buccaneers, the blockade runners. Without challenge, we're only
> half alive. We can go anywhere, and as long as we're together, it will belong to
> us. But, my pet, we'll never belong to it. That's for other people, not for us."

So I keep asking myself, and I may never know the answer, to whom do I belong?

Well, so long, for now.
