---
layout: post
title: 'Poking around a Pi: Part I'
subtitle: Initial setup
tags: [tech, linux]
description: Experiences with a Raspberry Pi 3B
---

Over a year ago, I got a [Raspberry Pi 3B][amazon]. Yahoo! JAPAN has this nice
system called [TechUP] for buying stuff (gadgets, books, subscriptions, etc.) to
improve your technical skills. A Pi is perfect --- it's well within the budget,
and you have lots of people using it for various projects, so there's a lot of
material online that you can learn from. And the models are always increasing in
power --- just look at the recently released Pi 4: a max of 4 GB of RAM
(potentially more), USB 3, and Gigabit Ethernet that doesn't share buses with
the USB ports. Today, though, I'll be talking about the Pi 3B and my experiments
with it.

It spent nearly a month collecting dust before I finally got around to booting
it. And when I did upgrade from polygonal tuits, I was faced with a tough
problem: which OS do I use?

1. Raspbian is pretty popular, and perhaps the first among equals. But: Stable
   releases of Debian-based distros like Raspbian tend to be heavily outdated.
   One of my goals with the Pi was to play with new software.
   I could hunt down repositories, or build stuff myself, but ¯\\\_(ツ)\_/¯
2. Ubuntu's main repositories don't support ARM. That's over on
   <http://ports.ubuntu.com/>. Even so, support in PPAs for ARM isn't that
   widespread.
3. Arch officially only supports the amd64/x86-64 architecture (they [dropped
   support for i686][arch-i686] some time ago). [ARM], like i686, is supported
   by the community. [Mirrors] are a bit of a problem. There are none in Japan.

Instead of going for Raspbian or Ubuntu, I opted for installing Arch Linux.  I
ended up picking Arch because it is my daily driver on my PC, and I already have
a box running Ubuntu serving as a … server. It was time to see how Arch would
hold up.

<!-- section -->

## Installation

It's been over a year since I installed it, so I don't remember specifics of any
problems I had during the installation. I don't think I had many --- except maybe
~~if~~ when I goofed up with some commands. I did have some concern that the
ARMv7 build that Arch Linux ARM recommended wouldn't be good enough, but I think
things have mostly turned out just fine.

Ah, yes! Like an idiot, I tried my default way of booting for system
installations: using an USB drive. And was greeted with a blank screen. I think
I fiddled with the KVM switch at first, then tried connecting everything to the Pi instead of the
switch and I even tried flashing the disk a couple of times. Finally I Googled and
realized that a Pi does not boot from an USB drive unless [it has been
configured to do so][usb-boot] --- *by booting from a microSD card.* That meant
buying one, and waiting a couple of days for its arrival.  Booting from the card
went fine: I finally saw the rainbow splash. (All told, it was about 6 weeks
since I bought the Pi that I first successfully booted it. Damn, I'm lazy.)

As I said before, Arch Linux itself worked pretty fine. I'd give it a Gold
rating (not Platinum), because I have had the occasional kernel panics over
the past year, about once every couple of months or so. For the moment, I have
stuck the `panic=10` bandaid on it.

The main issue --- I can't even really call it an issue --- is that the
community's preferred kernel is a bit old.  They track an LTS kernel, something
to do with custom firmware needed for some components. Since I don't use most of
it --- not the camera input, not the audio out, I don't even run a GUI on it ---
I think I could get away with running the latest, mainline kernel. Something to
test soon.  Shortly after I got the Pi, I wanted to try [iwd], the new wireless
network management daemon. However, the kernel in use then (4.12-ish, I think)
didn't support it. The kernel is currently 4.19 (following Arch's `linux-lts`),
where my PC runs 5.1. I think it does support iwd now, but I haven't gotten
around to testing it yet.

<!-- section -->

## Using a microSD card

Since I had to boot from a card anyway, I decided to go with it completely,
instead of configuring USB boot. This proved to be a mistake. I don't know if it
was the card I'd bought (a [Toshiba M203][toshiba]) or something with the Pi's
I/O, but damn, the system was slow. Tab completion, listing files, running
commands --- everything had a very noticeable, multi-second  delay. I mean, I
understand that the ARM CPU isn't comparable to the i7 on my PC, but this was
slower than anything I'd used in the past decade, except for SSH connections over
mobile internet. I thought it might be the CPU, but later, I realized it was the
I/O from the card, when I attached a USB hard disk to it. Listing files on the
disk was noticeably faster than doing so on the card. Then I noticed that
essentially anything which touched the card turned slow, like it was nearing the
accretion disk of a black hole. I decided to stick with the card for the time
being, but it did lead to a lot of frustration.

I finally moved to a USB flash drive a couple of weeks ago, and things have
drastically improved. I couldn't use my 8GB drive - it turned out to be just
a bit smaller than the 8GB microSD card. I could resize the partitions and all
that, but meh … I did have another 16GB one lying around. That one worked OK. I
had moved some stuff from the card to the hard drive for performance, but now I
have I moved them back to the flash drive, simplifying my setup.

<!-- section -->

## Power

I have a power strip with a couple of USB ports for charging, and I used one of
those for powering the Pi. And so I have had warnings about "under voltage"
pretty much from day zero. Even if I did buy a dedicated power adaptor for the
Pi, I didn't have spare slots on the power strip. I tried changing cables, using
shorter cables, etc. to no avail. I don't know if the under-voltage situations had any really impact on anything.
They always seemed to be resolved in seconds, and I didn't notice any relation
between their appearance and the aforementioned slow I/O. The one problem that
might be linked to it was a hard disk acting up.

I had two USB hard disks connected to the Pi, and the older one of them, a
Toshiba Canvio bought in May 2012, started having problems.  It would randomly
stop responding.  It could be the age of the drive, it could be the power ---
I'm not sure. IIRC a consumer hard disk lasts around 5 years, so this one had
already gone above and beyond. I managed to get all useful data off via my PC,
though, which is why I doubt if it was really failing. I had another aged disk
fail on an unrelated system around the same time, and that one just started
spewing I/O errors all over the place (couldn't even copy data reliably off it).
Or maybe I just experienced two failure modes of aging disks.

I decided to bite the bullet and get a dedicated power supply, but I didn't feel
like getting just power supply for the Pi. If I was going to have to mess with
my current power setup, doing it just for the Pi felt like a waste. Instead,
I got [a powered USB hub][hub] a few weeks ago, which also had an additional
port for USB charging. I moved all the peripherals to it (except the flash drive
used to boot it) and used it to power the Pi as well. I haven't had an
under-voltage situation since.

<!-- section -->

## What next?

So, what did I do with this Pi? I'll talk about the specifics in my next post.
But the tl;dr is this: I configured it to run Nextcloud, and in general function
as a file server with data on the hard disk.

It also serves as the gateway to my home. I have set up SSH (with only
public-key authentication allowed) and port-forwarded it over my router, so I
can access the Pi, and by extension (with some help from Wake-on-LAN) my PC as
well. A non-default SSH port means I don't see ~~many~~ any bots knocking on the
SSH door.

Overall, I'm pretty happy with the Pi. I'd like to upgrade to the Pi 4, mainly
for USB 3 and Gigabit networking, but I can live with the current performance.
The main bottleneck is my Internet (upload bandwidth a measly 10 Mbps), and
there's nothing that upgrading will *really* improve. I'd even say the Pi is
underutilized --- I'm barely using 200MB of RAM most of time, and the CPU's
mostly idle too. I'd say if you don't have 4K media, a Pi 3B is a perfectly fine
media server.

[amazon]: https://www.amazon.co.jp/dp/B01CHJRAOK/ref=cm_sw_r_tw_dp_U_x_XnOcDb1XCNV0H "Amazon Japan link"
[arch-i686]: https://www.archlinux.org/news/the-end-of-i686-support/
[ARM]: https://archlinuxarm.org/
[Mirrors]: https://archlinuxarm.org/about/mirrors
[TechUP]: https://linotice.tumblr.com/post/180646706959/20181130
[usb-boot]: https://www.raspberrypi.org/documentation/hardware/raspberrypi/bootmodes/msd.md
[toshiba]: https://store.shopping.yahoo.co.jp/jnh/TO3307M302EA.html
[hub]: https://www.amazon.co.jp/gp/product/B07PD1ZVLY/
[iwd]: https://lwn.net/Articles/770991/
