---
layout: post
title: My super-awesome System76 Bonobo Extreme!
tags: [tech]
---

I got the high-end Linux laptop available in the market: the System76 Bonobo
Extreme. It is certainly my prized possession, way more awesome than anything I
have ever owned, and anything I am likely to own in the next few years. I am not
a professional reviewer by a long shot, but after two weeks of using the bonx6,
I thought I'd post some of my observations.

First off, this thing is huge! A 17.3" screen, a full-fledged keyboard with an
inch-wide bezel on the sides, an inch-high base, a power brick that's more than
twice the size (in all dimensions) of that of my old Dell Vostro 1088's or that
of my parents' Samsung. There's an 89.2 WHr battery in it, which is quite
different in shape from the usual elongated ones: It's rectangular. The clickpad
is nice and large, with multi-touch. I love the large display - after years of
squeezing out every pixel from a 14" 1366x768 screen, having a 17.3" 1920x1080
display is like switching from my old hostel grounds to the football field. I
won't list the specifics, the list is available on the website.

There are a number of things which strike me about the bonx6:

- Full-sized arrow keys: Yay! Seriously, what is it with other more mainstream
  companies putting out half-sized, unusable arrow keys even on 15"+ laptops? My
  aforementioned Vostro, a 14", had full-fledged arrow keys. Who could possibly
  need a Shift key longer than certain parts of their anatomy? Also, the
  separate WiFi and Bluetooth keys are nice, as is the key to turn off the
  display. I used to use the `xset` command to do that, or wait on Windows. The
  backlighting (with the variety of colours) is very good.
- While the arrow keys are a huge plus, there is one annoyance about the
  keyboard: Instead of <kbd>Home</kbd> and <kbd>End</kbd> as main keys,
  <kbd>Page&nbsp;Up</kbd> and <kbd>Page&nbsp;Down</kbd> are the main ones and
  you have to use the Function key to use them. I dunno what statistics led them
  to this selection, but it's infernally irritating. I often use the
  <kbd>Home</kbd> and <kbd>End</kbd> keys, especially while typing. I only use
  the Page keys when reading, and that rarely. The other weird thing is the key
  next to the <kbd>Spacebar</kbd>, which would usually be the Context Menu key
  but is the Pipe/Slash key (`|`,``\``). I looked up the layouts available in
  Ubuntu and it seems to be some variant of US/International, and worked as a
  Multikey. I wasted no time in mapping it to the Context Menu key. (Why would I
  need two keys with the same function while eliminating one which has no
  duplicate anywhere else on the keyboard?)
- Four 3.5mm ports: S/PDIF, Line-in, mike, headphones. The sound quality from
  the headphones port on my Seinheiser CX-180 is noticeably poorer than that
  from the S/PDIF port. But getting that port to work decently on Ubuntu 12.10
  was a trial by trial-and-error. (No, that wasn't a typo. It was a trial, the
  kind I hadn't had to face on Ubuntu since 2010.) The sound either a)
  alternately rapidly between headphones and laptop speakers; or b) played on
  the right laptop speaker and on the left headphone. The PulseAudio Volume
  control program allowed me to get a handle on it, and now all is hunky-dory.
  Ubuntu 13.04 beta had no problem. The laptop speakers themselves are quite
  good, better than any laptop speaker I have heard (I have lived in a hostel
  with a variety of laptops, including ones with Altec Lansing speakers), loud,
  clear. And is that a sub-woofer on the bottom?
- The basic Targus clamshell bag is a very tight fit, and doesn't seem to have
  much in the name of padding. There's no Targus logo on the bag that I can see.
  And the weight of this behemoth makes carrying it without a backpack an
  arm-numbing strain. Thankfully, it just about fits into my Dell 15" backpack
  that I got with the Vostro.
- That was the good and the ugly. Now the weird: What is usually the Windows key
  has a small Ubuntu logo sticker on it. While it's cute, the back-lighting is
  blocked (but it's the only such key and so easily spotted). Considering that
  that keys with multiple functions (like entire top array) vary wildly from
  laptop to laptop, surely it wouldn't be that difficult to get buttons with
  proper Ubuntu logos on them? Or better yet, Tux?)
- The fingerprint reader and clickpad are nice, but it's the first experience
  I've had with either, so I can't judge them. The clickpad did initially seem
  to have too much friction. And now that I have got used to two-finger
  scrolling, there's now way I'd go back to edge-scrolling and a special button
  for right click. With tapping and two-finger tapping, the only time I actually
  click on it is for dragging. I've only used a MacBook once, but I doubt theirs
  is much better than this one. The fingerprint reader is especially useful on
  Ubuntu, for `sudo`. :) Side-note: If you encrypt your home directory while
  completing the Ubuntu setup, you will have to enter your password each time
  you log on. The fingerprint reader can only be used once the password has been
  used to decrypt the home directory.
- The battery is good, lasts around 200 minutes watching movies and TV shows on
  the headphone, all the while charging my Nexus<sup>4</sup>. It lasted an hour
  while playing *NFS Carbon*, but grew very hot during the process – the rest of
  the laptop was only mildly warm, but the battery, which is situated right at
  the front and is quite in contact with your lap, was hot. That said, while on
  external power, the laptop never gets very hot, but of the two huge fan vents,
  the one on the right seems to get more exercise. I have a Nexus<sup>4</sup>
  and I know when things get hot. The bonx6 doesn't. If the power usage of the
  graphics card (mine is the base one, 670 MX) could be lowered – it is around
  22 W even when in low-power mode – the battery could support 6+ hours of movie
  watching.  I have heard Optimus is a nightmare on Linux, but I sincerely hope
  nVidia cleans up their act and newer iterations of the Bonobo can support
  that.
- The port for the charging cable is in a very odd position: behind the laptop,
  close to the middle. It is decidedly strange, but isn't inconvenient. Even
  more weird, the cable head looks like a PS/2 port. And it seems to come loose
  very easily, which is mildly annoying.
- I installed Windows 8 (triple booting with the preinstalled Ubuntu 12.10 and
  the Raring beta), and had no problems using it (aside from Metro :P). The
  drivers provided by the knowledge76 website work great. I ran *Assassin's
  Creed III*, and at the highest settings, it ran smoothly, without any jerking
  or frame-skipping at all. I also ran the *Hitman: Absolution* benchmark: At
  Ultra settings, it had an average framerate of 10! But the benchmark scene is
  particularly detailed, featuring huge crowds, fireworks, birds-eye views – the
  Vostro with it's Radeon HD 4330 could only manage an avg frame rate of 13 even
  on the lowest settings, and this card breezes through games that brought the
  4330 to its knees. *FIFA 13*, *Need for Speed: The Run*, *L. A. Noire*, *Spec
  Ops: The Line* – all ran smoothly at the highest graphics settings.
- The 7200 rpm, 500 GB HDD is fast enough for me: an average of 90 MBps read
  speed and 40-60 MBps write speeds. The main issue is the secondary HDD slot –
  more precisely: Where the hell is it? The Vostro has a clearly demarcated
  section which can be easily unscrewed off to reveal the HDD and RAM slots. As
  far as I can tell, I'll have to pry off the whole back to get to the spare HDD
  slot, and I have a 500 GB disk lying around which I'd love to use as an
  internal disk once again. And I do plan on adding RAM.
- There are a couple of stickers on it: one for the SoundBlaster card and one
  for indicating HDMI support. Strangely, no Intel Inside/Core i7 sticker, no
  nVidia sticker. System76 did add a couple of metallic "Powered by Ubuntu"
  stickers, one of which immediately went on my bonx6 :) and the other on my
  parents' Samsung (which does, in fact, run Ubuntu 12.10 primarily).

I love everything else about the bonx6 – the display, the backlit keyboard, the
looks, the size, the clickpad, the desktop-beating level of power contained
within this beauty, the Ubuntu sticker that System76 gave which I put on it, the
abundance of ports, the fact that it came preinstalled with Ubuntu and that
System76 supports Linux and not Windows! Thank you so much, System76, for making
this awesome thing possible! And thanks to my best friend Roshan for telling me
about System76! You rock, bro!
