---
title: Les Misérables
layout: post
tags: [lit]
---

It has been a long time since I first read the novels which affected me the most
strongly: *Wuthering Heights*, *Jane Eyre*, *Crime and Punishment*, *War and
Peace*, *Great Expectations*, *David Copperfield*, *One Hundred Years of
Solitude*, *The Picture of Dorian Gray*, *Ivanhoe* and *Gone with the Wind*. The
first two I read when I was ten years old, or thereabouts; the last, *Gone with
the Wind*, three or four years ago. Since then, I've read a few books, but none
which created impressions as deep as they have. So much so, that I'd come to
doubt whether I would meet anybody as kind and as good as Melanie Wilkes, or
anyone as terrible as Dorian Gray. I felt that I wouldn't meet any love as
strong as the love between Catherine Earnshaw and Heathcliff, or the love for
Scarlet that Rhett had. Women like Jane Eyre, or Countess Natasha Rostova, or
Agnes Wickfield, or Scarlet O'Hara are rarely met with. But a lot of things
changed when I decided to correct a mistake that I had made, since I had never
got a chance to read Victor Hugo's *Les Misérables*, having read *The Hunchback
of Notre-Dame* years ago as an abridged version (curse those monstrosities, they
rob us of a great deal!). So when I chanced upon a Penguin Classics edition of
*Les Misérables*, a 1976 translation by Norman Denny, I seized it without a
second thought.

Victor Hugo is a master story-teller, and his plot is rich in twists and turns.
Some have parallels, as for example Thénardier's role in bringing the truth
about Jean Valjean's life to Marius's knowledge is very similar to Gollum's role
in destroying the Ring in *The Lord of the Rings.* Oh! Once I shuddered when
*The Lord of the Rings* was compared to the Harry Potter series, and now I
shudder to compare *The Lord of the Rings* to *Les Misérables.* I read *the Lay
of Beren and Luthién* and was deeply moved, and when I read the last three books
of *Volume V: Jean Valjean,* I did something which I have not done in years: I
wept. If, previously, someone had asked me to name the three greatest characters
I'd met, I would have named R. Daneel Olivaw, Melanie Wilkes and Sherlock
Holmes. Now, the list would be R. Daneel Olivaw, Melanie Wilkes and Jean
Valjean. All three are characterised by their infinite love and compassion,
their benevolence and goodness, their innate heroism, and their strength of
character. Indeed, Daneel is more human than some humans.

Norman Denny said that Victor Hugo is a poet, and rightly so. Only a poet would
indulge in a retelling of the Battle of Waterloo, only for creating a setting
for an ironical twist of fate. But the tale is well told, and only increases the
disgust for the dastardly act that follows, and I doubt even the best of authors
could have done any better. His novel is accused of being riddled with
unreadable digressions, but they serve to make the tale all the more
interesting, and are as much matter for the mind as Leo Tolstoy's philosophical
meanderings in *War and Peace.* In many a sense, I find Tolstoy's work (which he
considered to be something not quite a novel) is the only book comparable to
Hugo's work. It is interesting that one chronicles the beginning of Napoleon's
downfall, and the other the aftermath. Both have characters that rise from being
social outcasts to being angels on Earth, the one has Pierre Bezukhov, an
illegitimate son of a count, with a heart of gold and the innocence of a child,
and Jean Valjean, a paroled convict who came out with the blackest of minds and
was transformed into the most benevolent of men.  Both have their ingenues:
Natasha and Cosette (the picture at the top is of her as child); both have their
young men burdened with poverty and a title: Count Nicholas Rostov and Baron
Marius Pontmercy.


Hugo's tale of nineteenth century France is singular tale of misery and
wretchedness, and, at the same time, of hope and love. We follow the life of
Jean Valjean, sent to prison for stealing a piece of bread for his family,
ending up spending nineteen years in jail for repeated escape attempts, after he
is released on parole. He encounters the Bishop of Digne, an uncanonised saint,
who transforms him, and guides him to the path of goodness. He is entrusted with
the care of Cosette, the child of a poor girl called Fantine. As Cosette grows
into womanhood and meets and falls in love with Marius, the tale draws them all
into events leading up to the June Revolution of 1832 in Paris, weaving all the
threads in to a tapestry of singular beauty. We witness the gallant nature of
Jean Valjean, as he helps even those who dislike him or even hate him. We
witness the implacable nature of Inspector Javert, whose single-minded
dedication to the enforcement of law is the gravest of dangers to Valjean's
liberty. We witness the unchanging evil in Monsieur Thénardier, even as he seeks
to rob the gentleman who gives him alms, and to expose him to his son-in-law,
whilst unknowingly setting aright a number of misunderstandings. Éponine's pain
at having to aid Marius with his love for Cosette rends our hearts. Why, oh, why
do people have to suffer from unrequited love?

Admittedly, Hugo's tale has weaknesses. Nobody will paeans to the love between
Marius and Cosette. Nobody will sing ballads about Marius. But then, this tale
is not about them. This is about the upliftment of Les Misérables, the miserable
ones, the wretched ones, the very dregs of society, as seen in Valjean, Éponine
and Gavroche; Gavroche - that gallant little soul, to whom, one cannot help but
bow to and acknowledge his greatness of soul. Yet, with all this, as one flows
along with the tale, we do not even see these flaws, immersed in the curiosity
that makes us want to know: Will they ever have a chance at a better life? Will
they rise above their misery and find happiness?
