---
layout: post
title: Notes on Programming
tags: [programming]
---

I've always had a love of writing programs, maybe because I like to create
things. Different languages have different methods of punctuation; there are
different styles of indentation; there are different grammar styles, and so on.
Since at present I’m studying C/C++, I’ll be sticking to it in this monologue.

I have often observed that students often use incorrect practices while writing
programs. Maybe ‘incorrect’ is too strong a word; I suppose ‘improper’ would be
proper. I believe that students fall into such practices due to some
misconceptions or maybe when one particular instance needed it, and they have
stuck to it ever since. And if these practices work later on, or rather, fail to
hinder work, they never abandon it.

The most common example I can think of, is the use of this declaration:

{% highlight c %}
void main (void)
{% endhighlight %}

Now, I don’t know what they gain from using this form. I mean, how difficult can
it be include a

{% highlight c %}
return 0;
return EXIT_SUCCESS;
{% endhighlight %}

or whichever form they have been taught to use at the end of the definition.
After all, the line is, what, 9 characters long? How difficult could it be?
Agreed, the program will compile (in C), it will execute, and probably you have
set your compiler to ignore this malpractice, or disabled warnings altogether.

There is a reason why what we’re taught is called ANSI C/C++ or ISO C/C++. It’s
because the languages have been standardised, initially by ANSI (the American
National Standards Institute), and later on by the ISO (the International
Organization for Standardization). You may ask, so what? Some bunch of geeks
went and said, okay, you have to do this in this particular way and that in that
particular way; and nobody bothered to say no, so we’ve to follow them? That is
not so. We’ve been following rules made by others all our lives, and it’s not as
if all these rules are made for making life better. When conventions and
standards are set, it’s to make life easier. It may be not while doing the
actual work, but maybe while communicating our works or our results to others.
SI units make our life easier, by cutting across borders and languages when it
comes to units. In mathematics, when different people use different symbols, all
it does is create confusion. So too, in programming.

If you’ll bother to read the ISO standards on C++, you’ll see that the
convention for main() function lists:

{% highlight c %}
int main (void)
int main (int, char* [])
{% endhighlight %}

as the two possible types of `main()` declarations. An empty parameter list is
assumed to be have a `void` parameter. Admittedly, the ISO C standard does allow
other forms of declaration, including a return type of `void.`

There is no reason why a return value may not be provided. Indeed, providing a
`return` statement would indicate that the program has terminated. This would
prevent programs from falling of the end, when the end brace is reached without
a `return` statement. This could happen, accidentally, like when an incomplete
program is being tested, or when a `goto` statement wreaks havoc. So too, this
could help in finding unreachable portions of code, created possibly by
incorrect control statements. The last case has actually happened to me, when an
`if` statement had an always-true condition.

To a student of Computer Science and software engineering, to avoid returning
values is positively a crime. These values would be invaluable when testing
software, and you could call upon the system or other programs to execute,
depending upon the returned value. This could be useful in clean-up, or in
storing system details at the time of exit (which most OSes do in case of
abnormal termination of an application).  And this data would help in improving
your understanding of what actually happens in your program, as opposed to what
you think is happening. That last statement is quite important: it is often the
case that what you think is happening is quite different from what is actually
happening, especially in a language like C++, where most of the book-keeping and
memory management is done by you.

You may think (and quite rightly, too) that I’m harping on this point.  But the
reason I harp is that writing illegible code is a serious problem in today’s
open-source era. .You'll probably say that you're no hot-shot programmer, and
that you don't intend to publish any of your programs. However, you must
remember that even if you are only a beginner, your code could help someone else
in understanding the language. This especially applies to teachers and
textbooks. To use non-standard forms is to create confusion. And while

{% highlight c %}
void main (void)
{% endhighlight %}

may not be illegible, it could lead to confusion when the terminating statements
are reached. And further, it is by breaking such minor rules of conventions that
bigger breaks are made, and the very purpose of conventions and standards
defeated.

There are other such malpractices which I've observed, and upon these I'll
comment in later posts. For now, goodbye!

