/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.nio.charset.Charset;
import org.apache.harmony.awt.ContextStorage;
import org.apache.harmony.awt.datatransfer.DataProvider;
import org.apache.harmony.awt.datatransfer.DataTransferThread;
import org.apache.harmony.awt.datatransfer.NativeClipboard;
import org.apache.harmony.awt.datatransfer.TextFlavor;
import org.apache.harmony.awt.internal.nls.Messages;
import org.apache.harmony.misc.SystemUtils;

public abstract class DTK {
    private NativeClipboard nativeClipboard = null;
    private NativeClipboard nativeSelection = null;
    protected SystemFlavorMap systemFlavorMap;
    protected final DataTransferThread dataTransferThread = new DataTransferThread(this);

    protected DTK() {
        this.dataTransferThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DTK getDTK() {
        Object object = ContextStorage.getContextLock();
        synchronized (object) {
            block5: {
                if (!ContextStorage.shutdownPending()) break block5;
                return null;
            }
            DTK instance = ContextStorage.getDTK();
            if (instance == null) {
                instance = DTK.createDTK();
                ContextStorage.setDTK(instance);
            }
            return instance;
        }
    }

    public synchronized SystemFlavorMap getSystemFlavorMap() {
        return this.systemFlavorMap;
    }

    public synchronized void setSystemFlavorMap(SystemFlavorMap newFlavorMap) {
        this.systemFlavorMap = newFlavorMap;
    }

    public NativeClipboard getNativeClipboard() {
        if (this.nativeClipboard == null) {
            this.nativeClipboard = this.newNativeClipboard();
        }
        return this.nativeClipboard;
    }

    public NativeClipboard getNativeSelection() {
        if (this.nativeSelection == null) {
            this.nativeSelection = this.newNativeSelection();
        }
        return this.nativeSelection;
    }

    protected abstract NativeClipboard newNativeClipboard();

    protected abstract NativeClipboard newNativeSelection();

    public abstract void initDragAndDrop();

    public abstract void runEventLoop();

    public abstract DropTargetContextPeer createDropTargetContextPeer(DropTargetContext var1);

    public abstract DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent var1);

    private static DTK createDTK() {
        String name;
        switch (SystemUtils.getOS()) {
            case 1: {
                name = "org.apache.harmony.awt.datatransfer.windows.WinDTK";
                break;
            }
            case 2: {
                name = "org.apache.harmony.awt.datatransfer.linux.LinuxDTK";
                break;
            }
            default: {
                throw new RuntimeException(Messages.getString("awt.4E"));
            }
        }
        try {
            DTK dtk = (DTK)Class.forName(name).newInstance();
            return dtk;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getDefaultCharset() {
        return "unicode";
    }

    protected String[] getCharsets() {
        return new String[]{"UTF-16", "UTF-8", "unicode", "ISO-8859-1", "US-ASCII"};
    }

    public void initSystemFlavorMap(SystemFlavorMap fm) {
        String[] charsets = this.getCharsets();
        this.appendSystemFlavorMap(fm, DataFlavor.stringFlavor, "text/plain");
        this.appendSystemFlavorMap(fm, charsets, "plain", "text/plain");
        this.appendSystemFlavorMap(fm, charsets, "html", "text/html");
        this.appendSystemFlavorMap(fm, DataProvider.urlFlavor, "application/x-java-url");
        this.appendSystemFlavorMap(fm, charsets, "uri-list", "application/x-java-url");
        this.appendSystemFlavorMap(fm, DataFlavor.javaFileListFlavor, "application/x-java-file-list");
        this.appendSystemFlavorMap(fm, DataFlavor.imageFlavor, "image/x-java-image");
    }

    protected void appendSystemFlavorMap(SystemFlavorMap fm, DataFlavor flav, String nat) {
        fm.addFlavorForUnencodedNative(nat, flav);
        fm.addUnencodedNativeForFlavor(flav, nat);
    }

    protected void appendSystemFlavorMap(SystemFlavorMap fm, String[] charsets, String subType, String nat) {
        TextFlavor.addUnicodeClasses(fm, nat, subType);
        int i = 0;
        while (i < charsets.length) {
            if (charsets[i] != null && Charset.isSupported(charsets[i])) {
                TextFlavor.addCharsetClasses(fm, nat, subType, charsets[i]);
            }
            ++i;
        }
    }
}

