package com.example.instilostandfound;

import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.view.GravityCompat;
import androidx.drawerlayout.widget.DrawerLayout;

import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.material.navigation.NavigationView;

public class Navigation extends AppCompatActivity implements NavigationView.OnNavigationItemSelectedListener {
    private String username = null;
    private DrawerLayout drawerLayout;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_navigation);

        username = getIntent().getStringExtra("username");

        NavigationView navigationView = (NavigationView) findViewById(R.id.nav);
        navigationView.setNavigationItemSelectedListener(this);
        TextView ldapname = (TextView) navigationView.getHeaderView(0).findViewById(R.id.username);
        ldapname.setText(username);

        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        drawerLayout = findViewById(R.id.drawer_layout);
        ActionBarDrawerToggle navigation_toggle = new ActionBarDrawerToggle(this, drawerLayout, toolbar,
                R.string.open_navigation, R.string.close_navigation);
        drawerLayout.addDrawerListener(navigation_toggle);
        navigation_toggle.syncState();

       /* if(savedInstanceState==null){
            getSupportFragmentManager().beginTransaction().replace(R.id.fragment_container, new MainActivity()).commit();
        }*/
    }

    @Override
    public void onBackPressed() {
        if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
            drawerLayout.closeDrawer(GravityCompat.START);
        } else
            super.onBackPressed();
    }

    @Override
    public boolean onNavigationItemSelected(@NonNull MenuItem menuItem) {
        switch ((menuItem.getItemId())) {
            case R.id.post_found:
                Intent intent = new Intent(Navigation.this, FoundItem.class);
                intent.putExtra("username", username);
                startActivity(intent);
                break;
            case R.id.post_lost:
                intent = new Intent(Navigation.this, LostItem.class);
                intent.putExtra("username", username);
                startActivity(intent);
                break;
            case R.id.home:
                finish();
                startActivity(getIntent());
                break;
            case R.id.my_posts:
                intent = new Intent(this, RedirectMyPosts.class);
                intent.putExtra("username", username);
                startActivity(intent);
                break;
            case R.id.logout:
                finish();
                break;

        }
        drawerLayout.closeDrawer(GravityCompat.START);
        return true;
    }
}
