package com.example.instilostandfound;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.os.Bundle;
import android.widget.Toast;

import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.ValueEventListener;

import java.util.ArrayList;
import java.util.List;

public class MyPostsFoundRV extends AppCompatActivity {
    private RecyclerView mrecyclerView;
    private MyPostsAdaptor mAdaptor;

    private DatabaseReference mDatabaseRef;
    private List<CreateFoundObject> mPosts;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_my_posts_found_rv);

        mrecyclerView = findViewById(R.id.my_posts_rv);
        mrecyclerView.setHasFixedSize(true);
        mrecyclerView.setLayoutManager(new LinearLayoutManager(this));

        mPosts = new ArrayList<>();

        mDatabaseRef = FirebaseDatabase.getInstance().getReference("FoundData");
        mDatabaseRef.addValueEventListener(new ValueEventListener() {
            @Override
            public void onDataChange(@NonNull DataSnapshot dataSnapshot) {
                for(DataSnapshot postSnapShot : dataSnapshot.getChildren()){
                    CreateFoundObject post = postSnapShot.getValue(CreateFoundObject.class);
                    mPosts.add(post);
                }

                mAdaptor = new MyPostsAdaptor(MyPostsFoundRV.this, mPosts);
                mrecyclerView.setAdapter(mAdaptor);

            }

            @Override
            public void onCancelled(@NonNull DatabaseError databaseError) {

                Toast.makeText(MyPostsFoundRV.this, databaseError.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }
}
