package com.example.instilostandfound;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;

import java.util.List;

public class MyPostsAdaptor extends RecyclerView.Adapter<MyPostsAdaptor.myViewHolder> {
    private Context mcontext;
    private List<CreateFoundObject> mUploads;

    public MyPostsAdaptor(Context context, List<CreateFoundObject> uploads){
        mcontext = context;
        mUploads=uploads;
    }

    @NonNull
    @Override
    public MyPostsAdaptor.myViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(mcontext).inflate(R.layout.list_item, parent, false);
        return  new myViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MyPostsAdaptor.myViewHolder holder, int position) {
        CreateFoundObject current_post = mUploads.get(position);
        holder.textViewname.setText(current_post.getmTitle());
        Picasso.with(mcontext).load(current_post.getImageUrl())
                .fit()
                .centerCrop()
                .into(holder.imageView);
    }

    @Override
    public int getItemCount() {
        return mUploads.size();
    }

    public class myViewHolder extends RecyclerView.ViewHolder{

        public TextView textViewname;
        public ImageView imageView;
        public myViewHolder(@NonNull View itemView) {
            super(itemView);

            textViewname = itemView.findViewById(R.id.list_item_textview);
            imageView = itemView.findViewById(R.id.list_item_imageview);
        }

    }
}
