package com.example.instilostandfound;

import android.content.Context;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;

import java.util.List;

public class MyPostsAdaptor extends RecyclerView.Adapter<MyPostsAdaptor.myViewHolder> {
    private Context mcontext;
    private List<CreateFoundObject> mUploads;
    private OnItemClickListener mListener;

    public MyPostsAdaptor(Context context, List<CreateFoundObject> uploads){
        mcontext = context;
        mUploads=uploads;
    }

    @NonNull
    @Override
    public MyPostsAdaptor.myViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(mcontext).inflate(R.layout.list_item, parent, false);
        return  new myViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MyPostsAdaptor.myViewHolder holder, int position) {
        CreateFoundObject current_post = mUploads.get(position);
        holder.textViewname.setText(current_post.getmTitle());
        Picasso.with(mcontext).load(current_post.getImageUrl())
                .fit()
                .centerCrop()
                .into(holder.imageView);
    }

    @Override
    public int getItemCount() {
        return mUploads.size();
    }

    public class myViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener,
            View.OnCreateContextMenuListener, MenuItem.OnMenuItemClickListener{

        public TextView textViewname;
        public ImageView imageView;

        public myViewHolder(@NonNull View itemView) {
            super(itemView);

            textViewname = itemView.findViewById(R.id.list_item_textview);
            imageView = itemView.findViewById(R.id.list_item_imageview);
            itemView.setOnClickListener(this);
            itemView.setOnCreateContextMenuListener(this);
        }

        @Override
        public void onClick(View v) {
            if (mListener != null) {
                int position = getAdapterPosition();
                if (position != RecyclerView.NO_POSITION) {
                    mListener.onItemClick(position);
                }
            }

        }


            @Override
            public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
                menu.setHeaderTitle("Select Action");
                MenuItem doedit = menu.add(Menu.NONE, 1, 1, "Edit post");
                MenuItem delete = menu.add(Menu.NONE, 2, 2, "Delete post");

                doedit.setOnMenuItemClickListener(this);
                delete.setOnMenuItemClickListener(this);
            }

            @Override
            public boolean onMenuItemClick(MenuItem item) {
                if (mListener != null) {
                    int position = getAdapterPosition();
                    if (position != RecyclerView.NO_POSITION) {

                        switch (item.getItemId()) {
                            case 1:
                                mListener.oneditClick(position);
                                return true;
                            case 2:
                                mListener.onDeleteClick(position);
                                return true;
                        }
                    }
                }
                return false;
            }
        }

        public interface OnItemClickListener {
            void onItemClick(int position);

            void oneditClick(int position);

            void onDeleteClick(int position);
        }

        public void setOnItemClickListener(OnItemClickListener listener) {
            mListener = listener;
        }
    }
