package com.example.instilostandfound;
import com.example.instilostandfound.R;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.UploadTask;

import android.Manifest;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.icu.text.SimpleDateFormat;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;

import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;
import com.google.firebase.auth.FirebaseAuth;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.FileProvider;

import android.os.Environment;
import android.os.Handler;
import android.provider.MediaStore;
import android.util.Log;
import android.view.View;
import android.webkit.MimeTypeMap;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Spinner;
import android.widget.Toast;

import java.io.File;
import java.io.IOException;
import java.util.Date;
//import static android.app.Activity.RESULT_OK;
//import com.squareup.picasso.Picasso;

public class FoundItem extends AppCompatActivity implements View.OnClickListener{
    //private FirebaseAuth mAuth;
    EditText title;
    EditText place;
    EditText desc;
    EditText date;
    Spinner category;
    String username;
    ImageView camera;
    String[] items = new String[]{"Others","Electronic", "2", "three"};
    static final int REQUEST_IMAGE_CAPTURE = 1;
    private static final int REQUEST_CAMERARESULT=201;
    private static final int PICK_IMAGE_REQUEST = 1;
    private static final int CAMERA_REQUEST = 1888;
    private ImageView imageView;
    private static final int MY_CAMERA_PERMISSION_CODE = 100;
    private DatabaseReference mDatabase;
    private Uri mImageUri;
    // ...
    //mDatabase = FirebaseDatabase.getInstance().getReference();


// ...
    FirebaseDatabase database = FirebaseDatabase.getInstance();
    //DatabaseReference myRef = database.getReference("/FoundData/");
    DatabaseReference myRef = FirebaseDatabase.getInstance().getReference("FoundData");


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_found_item);
        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        username = getIntent().getStringExtra("username");
        title = findViewById(R.id.title);
        place = findViewById(R.id.place);
        desc = findViewById(R.id.desc);
        date = findViewById(R.id.date);
        category = findViewById(R.id.category);
        camera = findViewById(R.id.camera);
        camera.setOnClickListener(this);

  /*      findViewById(R.id.camera).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openFileChooser();
            }
        });*/

        findViewById(R.id.submit).setOnClickListener(this);
        ArrayAdapter<String> adapter = new ArrayAdapter<>(this, android.R.layout.simple_spinner_dropdown_item, items);
        category.setAdapter(adapter);

    }

    private void SubmitFound() {
        String Title = title.getText().toString().trim();
        String Place = place.getText().toString().trim();
        String Desc = desc.getText().toString().trim();
        String Date = date.getText().toString().trim();

        if (title.getText().toString().trim().isEmpty()) {
            title.setError("Please enter title");
            title.requestFocus();
            return;
        }

        if (place.toString().trim().isEmpty()) {
            place.setError("Please enter location");
            place.requestFocus();
            return;
        }


        createDemo upload = new createDemo(username,
                Title, Desc, Place, Date);
        String uploadId = myRef.push().getKey();
        Log.v("UploadID", uploadId);
        myRef.child(uploadId).setValue(upload);
        title.setText("");
        place.setText("");
        desc.setText("");

        Toast.makeText(FoundItem.this,"SUBMIT SUCCESSFUL",Toast.LENGTH_LONG).show();

    }

@Override
public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults)
{
    super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    if (requestCode == MY_CAMERA_PERMISSION_CODE)
    {
        if (grantResults[0] == PackageManager.PERMISSION_GRANTED)
        {
            Toast.makeText(this, "camera permission granted", Toast.LENGTH_LONG).show();
            Intent cameraIntent = new Intent(android.provider.MediaStore.ACTION_IMAGE_CAPTURE);
            startActivityForResult(cameraIntent, CAMERA_REQUEST);
        }
        else
        {
            Toast.makeText(this, "camera permission denied", Toast.LENGTH_LONG).show();
        }
    }
}

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data)
    {
        if (requestCode == CAMERA_REQUEST && resultCode == Activity.RESULT_OK)
        {
            Bitmap photo = (Bitmap) data.getExtras().get("data");
            camera.setImageBitmap(photo);
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.N)
    public void onClick(View view)
    {
        switch (view.getId())
        {
            case R.id.submit:
                SubmitFound();
                break;
            case R.id.camera:
                if (checkSelfPermission(Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED)
                {
                    requestPermissions(new String[]{Manifest.permission.CAMERA}, MY_CAMERA_PERMISSION_CODE);
                }
                else
                {
                    Intent cameraIntent = new Intent(android.provider.MediaStore.ACTION_IMAGE_CAPTURE);
                    startActivityForResult(cameraIntent, CAMERA_REQUEST);
                }
              /*  if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    if(FoundItem.this.checkSelfPermission(Manifest.permission.CAMERA)== PackageManager.PERMISSION_GRANTED){
                        ///method to get Images
                        dispatchTakePictureIntent();
                    }else{
                        if(shouldShowRequestPermissionRationale(Manifest.permission.CAMERA)){
                            Toast.makeText(FoundItem.this,"Your Permission is needed to get access the camera",Toast.LENGTH_LONG).show();
                        }
                        requestPermissions(new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE,Manifest.permission.READ_EXTERNAL_STORAGE,Manifest.permission.CAMERA}, REQUEST_CAMERARESULT);
                    }
                }else{
                    dispatchTakePictureIntent();
                }*/

                break;
        }
    }

}
