package com.example.instilostandfound;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.Toast;

public class MyPosts extends AppCompatActivity  {
    String items[] = new String[] {"apple", "banana"};

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_my_posts);

        ListView listView = (ListView) findViewById(R.id.listview);
        ArrayAdapter<String> adaptor = new ArrayAdapter<String>(this,
                android.R.layout.simple_list_item_1, items);
        listView.setAdapter(adaptor);

        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                Toast.makeText(MyPosts.this, items[position], Toast.LENGTH_SHORT).show();
                Intent intent = new Intent(MyPosts.this, ItemDetails.class);
                intent.putExtra("category", "Electronics");
                intent.putExtra("name", "Phone");
                intent.putExtra("key", "123");
                intent.putExtra("type", 1);
                startActivity(intent);
            }
        });
    }
}
