/*
 * Decompiled with CFR 0.152.
 */
package myjava.awt.datatransfer;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

final class MimeTypeProcessor {
    private static MimeTypeProcessor instance;

    private MimeTypeProcessor() {
    }

    static MimeType parse(String str) {
        if (instance == null) {
            instance = new MimeTypeProcessor();
        }
        MimeType res = new MimeType();
        if (str != null) {
            StringPosition pos = new StringPosition();
            MimeTypeProcessor.retrieveType(str, res, pos);
            MimeTypeProcessor.retrieveParams(str, res, pos);
        }
        return res;
    }

    static String assemble(MimeType type) {
        StringBuilder buf = new StringBuilder();
        buf.append(type.getFullType());
        Enumeration keys = type.parameters.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value = (String)type.parameters.get(name);
            buf.append("; ");
            buf.append(name);
            buf.append("=\"");
            buf.append(value);
            buf.append('\"');
        }
        return buf.toString();
    }

    private static void retrieveType(String str, MimeType res, StringPosition pos) {
        res.primaryType = MimeTypeProcessor.retrieveToken(str, pos).toLowerCase();
        pos.i = MimeTypeProcessor.getNextMeaningfulIndex(str, pos.i);
        if (pos.i >= str.length() || str.charAt(pos.i) != '/') {
            throw new IllegalArgumentException();
        }
        ++pos.i;
        res.subType = MimeTypeProcessor.retrieveToken(str, pos).toLowerCase();
    }

    private static void retrieveParams(String str, MimeType res, StringPosition pos) {
        res.parameters = new Hashtable();
        res.systemParameters = new Hashtable();
        while (true) {
            pos.i = MimeTypeProcessor.getNextMeaningfulIndex(str, pos.i);
            if (pos.i >= str.length()) {
                return;
            }
            if (str.charAt(pos.i) != ';') {
                throw new IllegalArgumentException();
            }
            ++pos.i;
            MimeTypeProcessor.retrieveParam(str, res, pos);
        }
    }

    private static void retrieveParam(String str, MimeType res, StringPosition pos) {
        String name = MimeTypeProcessor.retrieveToken(str, pos).toLowerCase();
        pos.i = MimeTypeProcessor.getNextMeaningfulIndex(str, pos.i);
        if (pos.i >= str.length() || str.charAt(pos.i) != '=') {
            throw new IllegalArgumentException();
        }
        ++pos.i;
        pos.i = MimeTypeProcessor.getNextMeaningfulIndex(str, pos.i);
        if (pos.i >= str.length()) {
            throw new IllegalArgumentException();
        }
        String value = str.charAt(pos.i) == '\"' ? MimeTypeProcessor.retrieveQuoted(str, pos) : MimeTypeProcessor.retrieveToken(str, pos);
        res.parameters.put(name, value);
    }

    private static String retrieveQuoted(String str, StringPosition pos) {
        StringBuilder buf = new StringBuilder();
        boolean check = true;
        ++pos.i;
        while (str.charAt(pos.i) != '\"' || !check) {
            char c = str.charAt(pos.i++);
            if (!check) {
                check = true;
            } else if (c == '\\') {
                check = false;
            }
            if (check) {
                buf.append(c);
            }
            if (pos.i != str.length()) continue;
            throw new IllegalArgumentException();
        }
        ++pos.i;
        return buf.toString();
    }

    private static String retrieveToken(String str, StringPosition pos) {
        StringBuilder buf = new StringBuilder();
        pos.i = MimeTypeProcessor.getNextMeaningfulIndex(str, pos.i);
        if (pos.i >= str.length() || MimeTypeProcessor.isTSpecialChar(str.charAt(pos.i))) {
            throw new IllegalArgumentException();
        }
        do {
            buf.append(str.charAt(pos.i++));
        } while (pos.i < str.length() && MimeTypeProcessor.isMeaningfulChar(str.charAt(pos.i)) && !MimeTypeProcessor.isTSpecialChar(str.charAt(pos.i)));
        return buf.toString();
    }

    private static int getNextMeaningfulIndex(String str, int i) {
        while (i < str.length() && !MimeTypeProcessor.isMeaningfulChar(str.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static boolean isTSpecialChar(char c) {
        return c == '(' || c == ')' || c == '[' || c == ']' || c == '<' || c == '>' || c == '@' || c == ',' || c == ';' || c == ':' || c == '\\' || c == '\"' || c == '/' || c == '?' || c == '=';
    }

    private static boolean isMeaningfulChar(char c) {
        return c >= '!' && c <= '~';
    }

    static final class MimeType
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = -6693571907475992044L;
        private String primaryType;
        private String subType;
        private Hashtable<String, String> parameters;
        private Hashtable<String, Object> systemParameters;

        MimeType() {
            this.primaryType = null;
            this.subType = null;
            this.parameters = null;
            this.systemParameters = null;
        }

        MimeType(String primaryType, String subType) {
            this.primaryType = primaryType;
            this.subType = subType;
            this.parameters = new Hashtable();
            this.systemParameters = new Hashtable();
        }

        boolean equals(MimeType that) {
            if (that == null) {
                return false;
            }
            return this.getFullType().equals(that.getFullType());
        }

        String getPrimaryType() {
            return this.primaryType;
        }

        String getSubType() {
            return this.subType;
        }

        String getFullType() {
            return String.valueOf(this.primaryType) + "/" + this.subType;
        }

        String getParameter(String name) {
            return this.parameters.get(name);
        }

        void addParameter(String name, String value) {
            if (value == null) {
                return;
            }
            if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1, value.length() - 2);
            }
            if (value.length() == 0) {
                return;
            }
            this.parameters.put(name, value);
        }

        void removeParameter(String name) {
            this.parameters.remove(name);
        }

        Object getSystemParameter(String name) {
            return this.systemParameters.get(name);
        }

        void addSystemParameter(String name, Object value) {
            this.systemParameters.put(name, value);
        }

        public Object clone() {
            MimeType clone = new MimeType(this.primaryType, this.subType);
            clone.parameters = (Hashtable)this.parameters.clone();
            clone.systemParameters = (Hashtable)this.systemParameters.clone();
            return clone;
        }
    }

    private static final class StringPosition {
        int i = 0;

        private StringPosition() {
        }
    }
}

