package com.example.instilostandfound;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class ItemDetails extends AppCompatActivity implements View.OnClickListener {
String category, name, key;
int type;
Bundle details_bundle;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_item_details);

        Intent intent = getIntent();
        details_bundle = intent.getExtras();

        ((TextView)findViewById(R.id.category)).setText(details_bundle.getString("category"));
        ((TextView)findViewById(R.id.name)).setText(details_bundle.getString("name"));
        ((TextView) findViewById(R.id.place)).setText(details_bundle.getString("place"));
        ((TextView) findViewById(R.id.description)).setText(details_bundle.getString("description"));
        ((TextView) findViewById(R.id.date)).setText(details_bundle.getString("date"));


        findViewById(R.id.edit_post).setOnClickListener(this);
        findViewById(R.id.resolve_post).setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()){
            case R.id.edit_post:
                if(details_bundle.getString("type").equals("lost")){
                    Intent intent = new Intent(ItemDetails.this, LostItem.class);
                    intent.putExtras(details_bundle);
                    startActivity(intent);
                }
                else if(details_bundle.getString("type").equals("found")){
                    Intent intent = new Intent(ItemDetails.this, FoundItem.class);
                    intent.putExtras(details_bundle);
                    startActivity(intent);
                }
                break;
            case R.id.resolve_post:
                break;
        }
    }
}
