package com.example.instilostandfound;

import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.database.Exclude;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CreateFoundObject implements Serializable {

    //private String mLDAPID;
    private String mImageUrl;
    private String mKey;
    private String mTitle;
    private String mDate;
    private String mLDAP;
    private String mDescription;
    private String mLocation;
    private String mCategory;
    private Date mDateFound;
    private String mtype;

    public CreateFoundObject() {

    }

    public CreateFoundObject(String LDAPID,String title ,String imageUrl, String location, String desc,
                             String category, Date datefound,String type) {
        if (LDAPID.trim().equals("")) {
            mLDAP = "No Name";
        }

        //mLDAPID = LDAPID;
        mImageUrl = imageUrl;
        mLDAP = FirebaseAuth.getInstance().getCurrentUser().getEmail();
        mDescription = desc;
        mLocation = location;
        mDateFound = datefound;
        mCategory = category;
        mTitle = title;
        mtype = type;

        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = new Date();
        mDate = df.format(date);



    }

    public String getLDAP() {
        return mLDAP;
    }
    public void setLDAP(String LDAP) { mLDAP= LDAP; }

    public String getmTitle() {
        return mTitle;
    }

    public void setmTitle(String mTitle) {
        this.mTitle = mTitle;
    }

    public String getImageUrl()
    {
        return mImageUrl;
    }
    public void setImageUrl(String imageUrl)
    {
        mImageUrl = imageUrl;
    }

    public String getmCategory()
    { return mCategory; }
    public void setmCategory(String category)
    { mCategory = category; }

    public Date getmDateFound()
    { return mDateFound; }
    public void setmDateFound(Date dateFound)
    { mDateFound = dateFound; }

    public String getmDescription()
    { return mDescription; }
    public void setmDescription(String desc)
    { mDescription = desc; }

    public String getmLocation()
    {return mLocation;}
    public void setmLocation(String location)
    { mLocation = location;}

    @Exclude
    public String getKey()
    {
        return mKey;
    }
    @Exclude
    public void setKey(String key)
    {
        mKey = key;
    }

    public String getDate()
    { return mDate; }
    public void setDate(String date)
    { mDate = date; }
}
