/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class TextFlavor {
    public static final Class[] unicodeTextClasses = new Class[]{String.class, Reader.class, CharBuffer.class, char[].class};
    public static final Class[] charsetTextClasses = new Class[]{InputStream.class, ByteBuffer.class, byte[].class};

    public static void addUnicodeClasses(SystemFlavorMap fm, String nat, String subType) {
        int i = 0;
        while (i < unicodeTextClasses.length) {
            String type = "text/" + subType;
            String params = ";class=\"" + unicodeTextClasses[i].getName() + "\"";
            DataFlavor f = new DataFlavor(String.valueOf(type) + params, type);
            fm.addFlavorForUnencodedNative(nat, f);
            fm.addUnencodedNativeForFlavor(f, nat);
            ++i;
        }
    }

    public static void addCharsetClasses(SystemFlavorMap fm, String nat, String subType, String charset) {
        int i = 0;
        while (i < charsetTextClasses.length) {
            String type = "text/" + subType;
            String params = ";class=\"" + charsetTextClasses[i].getName() + "\"" + ";charset=\"" + charset + "\"";
            DataFlavor f = new DataFlavor(String.valueOf(type) + params, type);
            fm.addFlavorForUnencodedNative(nat, f);
            fm.addUnencodedNativeForFlavor(f, nat);
            ++i;
        }
    }
}

