package com.example.instilostandfound;

import android.app.DatePickerDialog;
import android.app.ProgressDialog;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;

import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.storage.StorageTask;
import com.squareup.picasso.Picasso;

import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;

import android.util.Log;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Spinner;
import android.widget.TextView;

import java.io.Serializable;
import java.util.Calendar;

public class LostItem extends AppCompatActivity implements View.OnClickListener, Serializable {

    private static final String TAG = FoundItem.class.getSimpleName(); ;
    EditText title;
    EditText place;
    EditText desc;
    TextView date;
    Spinner category;
    String username;
    ImageView camera;
    String[] items = new String[]{"Others","Electronics", "Documents", "Clothes"};
    private static final int CAMERA_REQUEST = 1888;
    private ImageView imageView;
    private static final int MY_CAMERA_PERMISSION_CODE = 100;
    private DatabaseReference mDatabase;
    public Uri mImageUri;
    public Uri uploadSessionUri;
    int PICK_IMAGE_REQUEST = 111;
    public String callingclass;
    ProgressDialog pd;
    private StorageTask mUploadTask;
    private boolean updatedata;
    public String tempUri;

    DatePickerDialog.OnDateSetListener dateSetListener;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_lost_item);
        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        username = getIntent().getStringExtra("username");
        callingclass = getIntent().getStringExtra("CallingClass");
        title = findViewById(R.id.title);
        place = findViewById(R.id.place);
        desc = findViewById(R.id.desc);
        date = findViewById(R.id.date);
        category = findViewById(R.id.category);
        camera = findViewById(R.id.camera);
        camera.setOnClickListener(this);
        pd = new ProgressDialog(this);
        pd.setMessage("Uploading....");

        date.setOnClickListener(this);

        /*FloatingActionButton fab = findViewById(R.id.fab);
        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
                        .setAction("Action", null).show();
            }
        });*/

        findViewById(R.id.submit).setOnClickListener(this);
        ArrayAdapter<String> adapter = new ArrayAdapter<>(this, android.R.layout.simple_spinner_dropdown_item, items);
        category.setAdapter(adapter);
    }

    @RequiresApi(api = Build.VERSION_CODES.N)
    public void onClick(View view)
    {
        switch (view.getId())
        {
            case R.id.submit:
                //SubmitFound();
                break;
            case R.id.camera:
                Intent intent = new Intent();
                intent.setType("image/*");
                intent.setAction(Intent.ACTION_PICK);
                startActivityForResult(Intent.createChooser(intent, "Select Image"), PICK_IMAGE_REQUEST);
                break;
            case R.id.date:
                Calendar cal= Calendar.getInstance();
                int year = cal.get(Calendar.YEAR);
                int month = cal.get(Calendar.MONTH);
                int day = cal.get(Calendar.DAY_OF_MONTH);
                DatePickerDialog dialog = new DatePickerDialog(LostItem.this
                        ,android.R.style.Theme_Black,
                        dateSetListener, year, month, day);
                dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
                dialog.show();

                dateSetListener = new DatePickerDialog.OnDateSetListener() {
                    @Override
                    public void onDateSet(DatePicker datePicker, int year, int month, int day) {
                        month = month +1;
                        Log.d(TAG,"onDateSet: mm/dd/yyy: "+ month + "/" + day +"/" +year);
                        String dt= month+"/"+day+"/"+year;
                        date.setText(dt);

                    }
                };
                break;
        }
    }
    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (requestCode == PICK_IMAGE_REQUEST && resultCode == RESULT_OK && data != null && data.getData() != null) {
            mImageUri = data.getData();

            try {
                //getting image from gallery
                //Bitmap bitmap = MediaStore.Images.Media.getBitmap(getContentResolver(), mImageUri);

                //Setting image to ImageView
                //camera.setImageBitmap(bitmap);
                Picasso.with(LostItem.this).load(mImageUri)
                        .fit()
                        .centerCrop()
                        .into(camera);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

}
