package com.example.instilostandfound;
import android.content.Intent;
import android.os.Bundle;

import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.View;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.EditText;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity implements View.OnClickListener{
    private FirebaseAuth mAuth;
    EditText ldap_id;
    EditText ldap_password;
    public static final String ID = "com.example.instilostandfound.id";

    @Override
    protected void onCreate(Bundle savedInstanceState) {

// ...
// Initialize Firebase Auth

        mAuth = FirebaseAuth.getInstance();
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Toolbar toolbar = findViewById(R.id.toolbar);
        ldap_id = findViewById(R.id.LDAP_ID);
        ldap_password = findViewById(R.id.LDAP_PASSWORD);
        setSupportActionBar(toolbar);
        findViewById(R.id.login_btn).setOnClickListener(this);

       /*FloatingActionButton fab = findViewById(R.id.fab);
        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
                        .setAction("Action", null).show();
            }
        });*/
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    private void LDAPLogin()
    {
        final String ldap = ldap_id.getText().toString().trim();
        String id       = ldap_id.getText().toString().trim()+"@iitb.ac.in";
        String password = ldap_password.getText().toString().trim();
        if (id.isEmpty())
        {
            ldap_id.setError("Please enter your ldap id");
            ldap_id.requestFocus();
            return;
        }
        if (password.isEmpty())
        {
            ldap_password.setError("Please enter your ldap password ");
            ldap_password.requestFocus();
            return;
        }
        mAuth.signInWithEmailAndPassword(id,password).addOnCompleteListener(new OnCompleteListener<AuthResult>() {
            @Override
            public void onComplete(Task<AuthResult> task) {
                if(task.isSuccessful())
                {
                    Toast.makeText(MainActivity.this,"LOGIN SUCCESSFUL",Toast.LENGTH_LONG).show();
                    Intent intent = new Intent(MainActivity.this, Navigation.class);
                    intent.putExtra("username", ldap);
                    startActivity(intent);

                }
                else
                {
                    ldap_password.setText("");
                    Toast.makeText(MainActivity.this,"INVALID CREDENTIALS",Toast.LENGTH_LONG).show();
                }
            }
        });

    }
    public void onClick(View view)
    {
        switch (view.getId())
        {
            case R.id.login_btn:
                LDAPLogin();
                break;
        }
    }
}
