import logging
import os
from xml.dom.minidom import Identified
#Author: @meetdoshi
class Logger:
    '''
    Singleton logger class
    '''
    _instance = None
    _logHandler = None
    _formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
    def __new__(cls,*args,**kwargs):
        if not cls._instance:
            identifier = 'content-4_2'
            if not os.path.isdir("Logs/"):
                os.mkdir("Logs/")
            logHandler = logging.FileHandler("Logs/style_transfer_"+identifier+".log")
            logHandler.setFormatter(cls._formatter)
            cls._logHandler = logging.getLogger("Logs/style_transfer_"+identifier+".log")
            cls._logHandler.setLevel(logging.INFO)
            cls._logHandler.addHandler(logHandler)
            cls._instance = super(Logger, cls).__new__(cls,*args,**kwargs)
        return cls._instance

    def logger(self):
        return self._logHandler

'''
#Demo use
if __name__ == "__main__":
    a = Logger()
    b = Logger()
    print(a is b)
    INFO = a.logger()
    ERROR = b.logger()
    INFO.info("TEST")
    ERROR.info("ERROR")
'''
