import { Component, OnInit } from '@angular/core';
import { CookieService } from 'ngx-cookie-service';
import {FormBuilder, FormGroup} from '@angular/forms';

@Component({
  selector: 'app-profile',
  templateUrl: './profile.component.html',
  styleUrls: ['./profile.component.css']
})
export class ProfileComponent implements OnInit {
  firstFormGroup: FormGroup;
  secondFormGroup: FormGroup;
  thirdFormGroup: FormGroup;
  constructor(private cookieService: CookieService,private _formBuilder: FormBuilder) { 
    this.firstFormGroup = this._formBuilder.group({firstCtrl: ['']});
    this.secondFormGroup = this._formBuilder.group({secondCtrl: ['']});
    this.thirdFormGroup = this._formBuilder.group({thirdCtrl: ['']});
  }

  ngOnInit(): void {
  }
  setCookie(name: string,value: string){
    this.cookieService.set(name,value);
  }
  getCookie(name: string){
    return this.cookieService.get(name);
  }
  deleteCookie(name: string){
    this.cookieService.delete(name);
  }

}
