import { DialogRef } from '@angular/cdk/dialog';
import { Component, OnInit } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { Observable, Observer } from 'rxjs';
import { FetcherService } from '../fetcher.service';


@Component({
  selector: 'app-jira',
  templateUrl: './jira.component.html',
  styleUrls: ['./jira.component.css']
})
export class JiraComponent implements OnInit {
  id: number;
  name: string;
  constructor(public dialog:MatDialog, private fetcherService: FetcherService) {
    console.log(window.history.state);
    this.id = window.history.state.id;
    this.name = window.history.state.name;
  }
  calColCount(){
    console.log(window.innerWidth);
    if(window.innerWidth > 1000){
      return 4;
    }else if(window.innerWidth > 600){
      return 2;
    }else{
      return 1;
    }
  }

  openDialog(){
    const dialogRef = this.dialog.open(CreateTicketDialog);
    dialogRef.afterClosed().subscribe(result => {
      console.log(`Dialog result: ${result}`);
    });
  }

  calRowHeight(){
    let max_issue = Math.max(this.to_do.length,this.in_prog.length,this.done.length,this.backlog.length)
    let str = '';
    str = '1:'+(max_issue/3);
    return str;
  }

  fetchList(id: number) {
    //return dummy data of type entry
    if(id == 1){
      return TO_DO;
    }
    else if(id == 2){
      return IN_PROGRESS;
    }
    else if(id == 3){
      return DONE;
    }
    else{
      return BACKLOG;
    } 
  }

  moveToInProgress(tid: number){
    console.log(tid);
    console.log('Move to In Progress');
  }
  
  moveToDone(tid: number){
    console.log(tid);
    console.log('Move to Done');
  }

  moveToToDo(tid: number){
    console.log(tid);
    console.log('Move to ToDo');
  }
  ngOnInit(): void {
    this.fetcherService.setCurrentProjectId(this.id);
  }
  col_name = GRID_NAME;
  to_do = TO_DO;
  in_prog = IN_PROGRESS;
  done = DONE;
  backlog = BACKLOG;

}

@Component({
  selector: 'create-ticket-dialog',
  templateUrl: './create-ticket-dialog.html',
})
export class CreateTicketDialog {}


export const GRID_NAME = [
  {name: 'TO DO ISSUES', content: 'BLAH BLAH BLAH'},
  {name: 'IN PROGRESS', content: 'BLAH BLAH BLAH'},
  {name: 'DONE', content: 'BLAH BLAH BLAH'},
  {name: 'BACKLOG', content: 'BLAH BLAH BLAH'},
]

export const TO_DO = [
  {tid: 1, name: 'A', content: 'BLAH BLAH BLAH'},
  {tid: 2, name: 'B', content: 'BLAH BLAH BLAH'},
  {tid: 3, name: 'C', content: 'BLAH BLAH BLAH'},
  {tid: 4, name: 'D', content: 'BLAH BLAH BLAH'},
]
export const IN_PROGRESS = [
  {tid: 5, name: 'E', content: 'BLAH BLAH BLAH'},
  {tid: 6, name: 'F', content: 'BLAH BLAH BLAH'},
  {tid: 7, name: 'G', content: 'BLAH BLAH BLAH'},
  {tid: 8, name: 'H', content: 'BLAH BLAH BLAH'},
  {tid: 9, name: 'I', content: 'BLAH BLAH BLAH'},
  {tid: 10, name: 'J', content: 'BLAH BLAH BLAH'},
]
export const DONE = [
  {tid: 11, name: 'K', content: 'BLAH BLAH BLAH'},
  {tid: 12, name: 'L', content: 'BLAH BLAH BLAH'},
  {tid: 13, name: 'M', content: 'BLAH BLAH BLAH'},
]
export const BACKLOG = [
  {tid: 14, name: 'N', content: 'BLAH BLAH BLAH'},
  {tid: 15, name: 'O', content: 'BLAH BLAH BLAH'},
  {tid: 16, name: 'P', content: 'BLAH BLAH BLAH'},
]