import { Component, OnInit } from '@angular/core';
import {Observable, Observer} from 'rxjs';
import { FetcherService } from '../fetcher.service';


export interface entry{
  id: number;
  name: string;
  commitMessage: string;
  commitDate: Date;
  type: string;
  url: string;
}

export interface Section {
  id: number;
  name: string;
  commitDate: Date;
  url: string;
}

@Component({
  selector: 'app-github',
  templateUrl: './github.component.html',
  styleUrls: ['./github.component.css']
})
export class GithubComponent implements OnInit {
  projectId = NaN;
  constructor(private fetcherService: FetcherService) {
  }
  fetchData(id: number) {
    //return dummy data of type entry
    var files:entry[] = [
      {id: 1, name: "test", commitMessage: "test", commitDate: new Date('1/27/2022'), type: "folder", url: "test\n".repeat(10)},
      {id: 2, name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "folder", url: "test"},
      {id: 3, name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "folder", url: "test"},
      {id: 4, name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "folder", url: "test"},
      {id: 5, name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "folder", url: "test"},
      {id: 6, name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "file", url: "test"},
      {id: 7, name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "file", url: "test"},
      {id: 8, name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "file", url: "test"},
      {id: 9, name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "file", url: "test"},
      {id: 10, name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "file", url: "test"},
    ]
    return files;
  }
  submitFile(id: number,data: string) {
    //submit data to server
    console.log("submitting file");
    console.log(data);
    console.log(data.split("\n").length);
    document.getElementById("file-text")?.setAttribute("readonly", "true");
  }
  allowEditFile(){
    document.getElementById("file-text")?.removeAttribute("readonly");
  }
  files: entry[] = this.fetchData(this.projectId);

  ngOnInit(): void {
    this.projectId = this.fetcherService.getCurrentProjectId();
    console.log(this.projectId);
  }

}