from unittest.util import _MAX_LENGTH
from django.db import models
import uuid
# Create your models here.
class Users(models.Model):
    uid = models.UUIDField(primary_key=True,default=uuid.uuid4,editable=False)
    email = models.CharField(max_length=30)
    password = models.CharField(max_length=30)
    role = models.CharField(max_length=30)
    created_date = models.DateTimeField(auto_now_add=True,blank=True)
    active = models.BooleanField(default=False)
    profile_img = models.CharField(max_length=100,default='blank.png')
    bio = models.CharField(max_length=100,default='')
    first_name = models.CharField(max_length=30,default='John')
    last_name = models.CharField(max_length=30,default='Doe')

    def __str__(self):
        return f'{self.uid=},{self.email=},{self.password=},{self.role=},{self.created_date=},{self.active=}, {self.profile_img=}, {self.bio=}, {self.first_name=}, {self.last_name=}'

class Projects(models.Model):
    pid = models.UUIDField(primary_key=True,default=uuid.uuid4,editable=False)
    pname = models.CharField(max_length=50)
    created_date = models.DateTimeField(auto_now_add=True,blank=True)
    powner = models.CharField(max_length=50)
    git_id = models.CharField(max_length=50,default='')
    jira_id = models.CharField(max_length=50, default='')
    confluence_id = models.CharField(max_length=50, default='')
    description = models.CharField(max_length=100,default='This project is about...')
    content = models.CharField(max_length=100,default='Project Content')


    def __str__(self):
        return f'{self.pid=},{self.pname=},{self.created_date=},{self.powner=}'

class Access(models.Model):
    aid = models.UUIDField(primary_key=True,default=uuid.uuid4,editable=False)
    pname = models.CharField(max_length=50)
    pid = models.ForeignKey(Projects,on_delete=models.CASCADE)
    uid = models.ForeignKey(Users,on_delete=models.CASCADE)
    alevel = models.IntegerField(default=0) # 0 = No access 1 = View only 2 = RW 3 = Owner

    def __str__(self):
        return f'{self.aid=},{self.pname=},{self.pid=},{self.uid=},{self.alevel=}'

class Tickets(models.Model):
    tid = models.UUIDField(primary_key=True,default=uuid.uuid4,editable=False)
    name = models.CharField(max_length=50)
    content = models.CharField(max_length=50)
    status = models.CharField(max_length=50)
    pid = models.CharField(max_length=50)

    def __str__(self) -> str:
        return f'{self.tid=},{self.name=},{self.content=},{self.status},{self.pid=}'

