import { DialogRef } from '@angular/cdk/dialog';
import { Component, Inject, OnInit } from '@angular/core';
import { MatDialog, MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { Observable, Observer } from 'rxjs';
import { FetcherService } from '../fetcher.service';

export interface TicketData {
  tid: string;
  pname:string;
  tname: string;
  tcontent: string;
}

export interface ListData{
  tid: string;
  name : string;
  content: string;
}

@Component({
  selector: 'app-jira',
  templateUrl: './jira.component.html',
  styleUrls: ['./jira.component.css']
})
export class JiraComponent implements OnInit {
  id: number;
  name: string;
  temp_tname = '';
  temp_tcontent = '';
  temp_tid = '';
  constructor(public dialog:MatDialog, private fetcherService: FetcherService) {
    console.log(window.history.state);
    this.id = window.history.state.id;
    this.name = window.history.state.name;
  }
  calColCount(){
    console.log(window.innerWidth);
    if(window.innerWidth > 1000){
      return 4;
    }else if(window.innerWidth > 600){
      return 2;
    }else{
      return 1;
    }
  }

  openDialog(){
    const dialogRef = this.dialog.open(CreateTicketDialog, {
      data: {tid: this.temp_tid, pname:this.name, tname: this.temp_tname, tcontent: this.temp_tcontent,
      },
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('Dialog result:', result.tname, result.tcontent);
      this.to_do.push({tid: '10', name: result.tname, content: result.tcontent});

    });
  }

  calRowHeight(){
    let max_issue = Math.max(this.to_do.length,this.in_prog.length,this.done.length,this.backlog.length)
    let str = '';
    str = '1:'+(max_issue/3);
    return str;
  }

  fetchList(id: number) {
    //return dummy data of type entry
    if(id == 1){
      return TO_DO;
    }
    else if(id == 2){
      return IN_PROGRESS;
    }
    else if(id == 3){
      return DONE;
    }
    else{
      return BACKLOG;
    } 

  }
  moveToInProgress(tid: string, list_name: string ){
    if (list_name == 'to_do') {
      for (let i = 0; i< this.to_do.length; i++){
        if( this.to_do[i].tid == tid){
          this.in_prog.push(this.to_do[i]);
          this.to_do.splice(i,1);
          console.log(this.to_do);
          break;
        }
      }
    } else if (list_name == 'done') {
      for (let i = 0; i< this.done.length; i++){
        if( this.done[i].tid == tid){
          this.in_prog.push(this.done[i]);
          this.done.splice(i,1);
          console.log(this.done);
          break;
        }
      }
    } else if (list_name == 'backlog') {
      for (let i = 0; i< this.backlog.length; i++){
        if( this.backlog[i].tid == tid){
          this.in_prog.push(this.backlog[i]);
          this.backlog.splice(i,1);
          console.log(this.backlog);
          break;
        }
      }
    }

    console.log(list_name);
    console.log(tid);
    console.log('Move to In Progress');
  }
  
  moveToDone(tid: string, list_name: string ){
    if (list_name == 'to_do') {
      for (let i = 0; i< this.to_do.length; i++){
        if( this.to_do[i].tid == tid){
          this.done.push(this.to_do[i]);
          this.to_do.splice(i,1);
          console.log(this.to_do);
          break;
        }
      }
    } else if (list_name == 'in_prog') {
      for (let i = 0; i< this.in_prog.length; i++){
        if( this.in_prog[i].tid == tid){
          this.done.push(this.in_prog[i]);
          this.in_prog.splice(i,1);
          console.log(this.in_prog);
          break;
        }
      }
    } else if (list_name == 'backlog') {
      for (let i = 0; i< this.backlog.length; i++){
        if( this.backlog[i].tid == tid){
          this.done.push(this.backlog[i]);
          this.backlog.splice(i,1);
          console.log(this.backlog);
          break;
        }
      }
    }
  }

  moveToToDo(tid: string, list_name: string ){
    if (list_name == 'in_prog') {
      for (let i = 0; i< this.in_prog.length; i++){
        if( this.in_prog[i].tid == tid){
          this.to_do.push(this.in_prog[i]);
          this.in_prog.splice(i,1);
          console.log(this.in_prog);
          break;
        }
      }
    } else if (list_name == 'done') {
      for (let i = 0; i< this.done.length; i++){
        if( this.done[i].tid == tid){
          this.to_do.push(this.done[i]);
          this.done.splice(i,1);
          console.log(this.done);
          break;
        }
      }
    } else if (list_name == 'backlog') {
      for (let i = 0; i< this.backlog.length; i++){
        if( this.backlog[i].tid == tid){
          this.to_do.push(this.backlog[i]);
          this.backlog.splice(i,1);
          console.log(this.backlog);
          break;
        }
      }
    }
    console.log(list_name);
    console.log(tid);
    console.log('Move to ToDo');
  }
  ngOnInit(): void {
    this.fetcherService.setCurrentProjectId(this.id);
  }
  col_name = GRID_NAME;
  to_do = TO_DO;
  in_prog = IN_PROGRESS;
  done = DONE;
  backlog = BACKLOG;

}

@Component({
  selector: 'create-ticket-dialog',
  templateUrl: './create-ticket-dialog.html',
  styleUrls: ['./jira.component.css']
})
export class CreateTicketDialog {
  constructor(
    public dialogRef: MatDialogRef<CreateTicketDialog>,
    @Inject(MAT_DIALOG_DATA) public data:TicketData,
  ){}

  onNoClick(){
    this.dialogRef.close();
  }
}


export const GRID_NAME = [
  {name: 'TO DO ISSUES', content: 'BLAH BLAH BLAH'},
  {name: 'IN PROGRESS', content: 'BLAH BLAH BLAH'},
  {name: 'DONE', content: 'BLAH BLAH BLAH'},
  {name: 'BACKLOG', content: 'BLAH BLAH BLAH'},
]

export var TO_DO = [
  {tid: '1', name: 'A', content: 'BLAH BLAH BLAH'},
  {tid: '2', name: 'B', content: 'BLAH BLAH BLAH'},
  {tid: '3', name: 'C', content: 'BLAH BLAH BLAH'},
  {tid: '4', name: 'D', content: 'BLAH BLAH BLAH'},
]
export var IN_PROGRESS = [
  {tid: '5', name: 'E', content: 'BLAH BLAH BLAH'},
  {tid: '6', name: 'F', content: 'BLAH BLAH BLAH'},
  {tid: '7', name: 'G', content: 'BLAH BLAH BLAH'},
  {tid: '8', name: 'H', content: 'BLAH BLAH BLAH'},
  {tid: '9', name: 'I', content: 'BLAH BLAH BLAH'},
  {tid: '10', name: 'J', content: 'BLAH BLAH BLAH'},
]
export var DONE = [
  {tid: '11', name: 'K', content: 'BLAH BLAH BLAH'},
  {tid: '12', name: 'L', content: 'BLAH BLAH BLAH'},
  {tid: '13', name: 'M', content: 'BLAH BLAH BLAH'},
]
export var BACKLOG = [
  {tid: '14', name: 'N', content: 'BLAH BLAH BLAH'},
  {tid: '15', name: 'O', content: 'BLAH BLAH BLAH'},
  {tid: '16', name: 'P', content: 'BLAH BLAH BLAH'},
]