import { Component, Inject, inject, OnInit } from '@angular/core';
import { CookieService } from 'ngx-cookie-service';
//import { PROJECTS } from './projects';
import { GET_REPOS_API } from '../urls';
import { getProjectDetailsResponse } from '../responses';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { Router } from '@angular/router';
import { PROJECTS } from './projects';
import { MatDialog, MatDialogRef} from '@angular/material/dialog';
import { ResourceLoader } from '@angular/compiler';

export interface Tile {
  color: string;
  cols: number;
  rows: number;
  text: string;
}

@Component({
  selector: 'app-home',
  templateUrl: './home.component.html',
  styleUrls: ['./home.component.css']
})
export class HomeComponent implements OnInit {
  project_stat$ = new Observable<getProjectDetailsResponse>;
  projects = new Array<{pid:string;pname:string;created_date:string;powner:string;confluence_id:string;git_id:string;jira_id:string;content:string;description:string}>();
  constructor(public dialog:MatDialog, private cookieService: CookieService, private router: Router, private http: HttpClient ) { }
  setCookie(kname: string,value: string){
    this.cookieService.set(kname,value);
  }
  getCookie(kname: string){
    return this.cookieService.get(kname);
  }
  deleteCookie(kname: string){
    this.cookieService.delete(kname);
  }
  calColCount(){
    //console.log(window.innerWidth);
    if(window.innerWidth > 1000){
      return 3;
    }else if(window.innerWidth > 600){
      return 2;
    }else{
      return 1;
    }
  }

  openLogoutDialog(){
    const dialogRef = this.dialog.open(LogoutDialog);
    dialogRef.afterClosed().subscribe(result => {
      console.log('Logout Result:', result)
    })
  }
  ngOnInit(): void {
    console.log(this.getCookie('uid'));
    this.project_stat$ = this.http.get<getProjectDetailsResponse>(GET_REPOS_API+'?uid='+ this.getCookie('uid'));
    this.project_stat$.subscribe(
      (response) => {
        console.log(response);
        if (response.status == true) {
          for (let i = 0; i < response.repos.length; i++) {
            this.projects.push(response.repos[i]);
          }
          console.log(this.projects);
        } 
        else{
          alert('Invalid Credentials');
        }
      }
    );
  }
  tiles: Tile[] = [
    {text: 'One', cols: 1, rows: 1, color: 'white'},
  ];
}

@Component({
  selector: 'logout-dialog',
  templateUrl: './logout-dialog.html',
  styleUrls: ['./home.component.css']
})
export class LogoutDialog{
  constructor(
    public dialogRef: MatDialogRef<LogoutDialog>,
    private cookieService: CookieService,
    private router: Router
  ){

  }

  onCancelClick(){
    this.dialogRef.close();
  }
  onLogoutClick(){
    this.cookieService.deleteAll();
    this.router.navigate(['/login']);
    this.dialogRef.close();
  }
}