import { Component, OnInit } from '@angular/core';
import {Observable, Observer} from 'rxjs';
import { FetcherService } from '../fetcher.service';
import { GET_GIT_FILES_API, POST_FILE_CHANGE_API } from '../urls';
import { getGitFilesResponse, postFileChangesResponse } from '../responses';
import { HttpClient } from '@angular/common/http';
import { Router } from '@angular/router';
import { CookieService } from 'ngx-cookie-service';

export interface entry{
  id: string;
  name: string;
  commitMessage: string;
  commitDate: Date;
  type: string;
  content: string;
}

export interface Section {
  id: number;
  name: string;
  commitDate: Date;
  url: string;
}

@Component({
  selector: 'app-github',
  templateUrl: './github.component.html',
  styleUrls: ['./github.component.css']
})
export class GithubComponent implements OnInit {
  projectId = '';
  git_id = '';
  getGitFiles_stat$ = new Observable<getGitFilesResponse>;
  postFileChange_stat$ = new Observable<postFileChangesResponse>;

  constructor(private fetcherService: FetcherService, private http: HttpClient, private router: Router, private cookieService: CookieService) { 
  }
  fetchData(id: string) {
    //return dummy data of type entry
    var files:entry[] = [
      {id: '1', name: "test", commitMessage: "test", commitDate: new Date('1/27/2022'), type: "folder", content: "test\n".repeat(10)},
      {id: '2', name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "folder", content: "test"},
      {id: '3', name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "folder", content: "test"},
      {id: '4', name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "folder", content: "test"},
      {id: '5', name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "folder", content: "test"},
      {id: '6', name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "file", content: "test"},
      {id: '7', name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "file", content: "test"},
      {id: '8', name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "file", content: "test"},
      {id: '9', name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "file", content: "test"},
      {id: '10', name: "test", commitMessage: "test", commitDate: new Date('1/1/2022'), type: "file", content: "test"},
    ]
    return files;
  }
  submitFile(id: string,data: string) {
    //submit data to server
    console.log("submitting file");
    console.log(data);
    console.log(data.split("\n").length);
    this.postFileChange_stat$ = this.http.post<postFileChangesResponse>(POST_FILE_CHANGE_API,{
      "pid": this.projectId,
      "file_id": id,
      "content": data
    });
    this.postFileChange_stat$.subscribe((data) => {
      console.log(data);
    });
    for (let i = 0; i < document.getElementsByClassName("file-text").length; i++) {
      document.getElementsByClassName("file-text")[i].setAttribute("readonly", "true");
    }
  }
  allowEditFile(){
    for (let i = 0; i < document.getElementsByClassName("file-text").length; i++) {
      document.getElementsByClassName("file-text")[i].removeAttribute("readonly");
    }
  }
  //files: entry[] = this.fetchData(this.projectId);
  files: entry[] = this.fetchData(this.projectId);

  ngOnInit(): void {
    //this.projectId = this.fetcherService.getCurrentProjectId();
    this.projectId = this.cookieService.get("pid");
    console.log(this.projectId);
    this.getGitFiles_stat$ = this.http.get<getGitFilesResponse>(GET_GIT_FILES_API+'?pid=' +this.projectId);
    this.getGitFiles_stat$.subscribe((data) => {
      //console.log(data);
      if (data.status == true) {
        this.git_id = data.files[0].git_id;
        //console.log(this.git_id);
        this.http.get('assets/'+this.git_id, {responseType: 'text'}).subscribe((data) => {
          //console.log(data);
          var files:entry[] = [];
          var lines = data.split("\n");
          for (let i = 0; i < lines.length; i++) {
            var line = lines[i].split(",");
            var file:entry = {id: line[0], name: line[1], commitMessage: line[2], commitDate: new Date(line[3]), type: line[4], content: line[5]};
            files.push(file);
          }
          this.files = files;
          this.files.pop();
          this.files.shift();
        });
      }
      else {
        console.log("failure");
      }
    });
    }

}