export interface LoginResponse {
    email: string;
    uid: string;
    status: boolean;
}
export interface RegisterResponse {
    uid: string;
    status: boolean;
}

export interface getUserDetailsResponse {
    user: [
        {
            email: string;
            password: string;
            role: string;
            uid: string;
            created_date: string;
            active: boolean;
            profile_img: string;
            bio: string;
            first_name: string;
            last_name: string;
        }
    ];
    status: boolean;
}

export interface postUserDetailsResponse {
    status: boolean;
}

export interface getProjectDetailsResponse {
    repos: [
        {
            pid: string;
            pname: string;
            created_date: string;
            powner: string;
            confluence_id: string;
            git_id: string;
            jira_id: string;
            content: string;
            description: string;
        }
    ];
    status: boolean;
}

export interface getGitFilesResponse {
    files: [
        {
            git_id: string;
        }
    ];
    status: boolean;
}

export interface postFileChangesResponse {
    status: boolean;
}


export interface getJiraTicketsResponse {
    files: [
        {
            tid: string;
            name: string;
            content: string;
            status: string;
            pid_id: string;
        }
    ];
    status: boolean;
}

export interface updateJiraTicketResponse {
    status: boolean;
}

export interface createJiraTicketResponse {
    tid: string;
    status: boolean;
}

export interface getConfluencePagesResponse {
    pages: string;
    status: boolean;
}

