import { Component, OnInit } from '@angular/core';
import { Observable, Observer } from 'rxjs';
import { FetcherService } from '../fetcher.service';
import { CookieService } from 'ngx-cookie-service';
import { MatDialog } from '@angular/material/dialog';
import { LogoutDialog } from '../home/home.component';

export interface ExampleTab {
  label: string;
  content: string;
}

/**
 * Set the tabInd as 1, and the same is being captured by the project component. On the change of event the tabInd is updated and other components are rendered.
 */
@Component({
  selector: 'app-project',
  templateUrl: './project.component.html',
  styleUrls: ['./project.component.css']
})
export class ProjectComponent implements OnInit {
  id: number;
  name: string;
  tabInd = 1;
  asyncTabs: Observable<ExampleTab[]>;
  pid = '';
  constructor(private dialog:MatDialog, private fetcherService: FetcherService, private cookieService: CookieService) {
    console.log(window.history.state);
    this.id = window.history.state.id;
    this.name = window.history.state.name;
    this.asyncTabs = new Observable((observer: Observer<ExampleTab[]>) => {
      setTimeout(() => {
        observer.next([
          {label: 'Github', content: 'Content 1'},
          {label: 'Confluence', content: 'Content 2'},
          {label: 'JIRA', content: 'Content 3'},
        ]);
      }, 1000);
    });
  }

  
  changeTab(event: any) {
    this.tabInd = event.index+1;
  }

  openLogoutDialog(){
    const dialogRef = this.dialog.open(LogoutDialog);
    dialogRef.afterClosed().subscribe(result => {
      console.log('Logout Result:', result)
    })
  }

  /**
   * On Initialization, get Project ID from cookie.
   */
  ngOnInit(): void {
    this.pid = this.cookieService.get('pid');
    if (this.id != undefined && this.pid != this.id.toString()) {
      this.cookieService.set('pid', this.id.toString());
    }
    this.fetcherService.setCurrentProjectId(this.id);
    console.log(this.id);
  }

}
