import { Component, OnInit } from '@angular/core';
import { CookieService } from 'ngx-cookie-service';
import {FormBuilder, FormGroup} from '@angular/forms';
import { GET_USER_DETAILS_API, POST_USER_DETAILS_API } from '../urls';
import { getUserDetailsResponse, postUserDetailsResponse } from '../responses';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { Router } from '@angular/router';
import { MatDialog} from '@angular/material/dialog';
import { LogoutDialog } from '../home/home.component';

/**
 * This component is responsible for maintaining and updating user profile.
 */
@Component({
  selector: 'app-profile',
  templateUrl: './profile.component.html',
  styleUrls: ['./profile.component.css']
})
export class ProfileComponent implements OnInit {
  firstFormGroup: FormGroup;
  secondFormGroup: FormGroup;
  thirdFormGroup: FormGroup;
  getUser$ = new Observable<getUserDetailsResponse>;
  postUser$ = new Observable<postUserDetailsResponse>;
  uid = this.getCookie('uid');
  email = "";
  password = "";
  role = "";
  created_date = "";
  active_stat = false;
  profile_img = "";
  bio = "";
  first_name = "";
  last_name = "";
  full_name = "";

  constructor(private dialog: MatDialog, private cookieService: CookieService,private _formBuilder: FormBuilder, private http:HttpClient, private router: Router) { 
    this.firstFormGroup = this._formBuilder.group({firstCtrl: ['']});
    this.secondFormGroup = this._formBuilder.group({secondCtrl: ['']});
    this.thirdFormGroup = this._formBuilder.group({thirdCtrl: ['']});
  }

  /**
   * Post User details to backend server.
   */
  updateProfile(){
    this.full_name = this.firstFormGroup.value.firstCtrl.toString();
    this.first_name = this.full_name.split(",")[0];
    this.last_name = this.full_name.split(",")[1];
    this.bio = this.thirdFormGroup.value.thirdCtrl.toString();
    this.profile_img = this.secondFormGroup.value.secondCtrl.toString();
    this.profile_img = this.profile_img.split("\\").slice(-1)[0];
    this.postUser$ = this.http.post<postUserDetailsResponse>(POST_USER_DETAILS_API, {
      uid: this.uid,
      first_name: this.first_name,
      last_name: this.last_name,
      profile_img: this.profile_img,
      bio: this.bio
    });
    this.postUser$.subscribe(
      (response) => {
        console.log(response);
        if (response.status == true) {
          alert('Profile Updated');
          //this.router.navigate(['/home']);
        }
        else{
          alert('Invalid Entries');
        }
      }
    );
  }
  openLogoutDialog(){
    const dialogRef = this.dialog.open(LogoutDialog);
    dialogRef.afterClosed().subscribe(result => {
      console.log('Logout Result:', result)
    })
  }

  /**
   * This function get create a get request for given user and get the user details from the backend server.
   */
  ngOnInit(): void {
    this.getUser$ = this.http.get<getUserDetailsResponse>(GET_USER_DETAILS_API + "?uid=" + this.uid);
    this.getUser$.subscribe(
      (response) => {
        if (response.status == true) {
          this.email = response.user[0].email;
          this.password = response.user[0].password;
          this.role = response.user[0].role;
          this.created_date = response.user[0].created_date;
          this.active_stat = response.user[0].active;
          this.profile_img = response.user[0].profile_img;
          this.bio = response.user[0].bio;
          this.first_name = response.user[0].first_name;
          this.last_name = response.user[0].last_name;
        } 
        else{
          alert('Invalid Credentials');
        }
      }
    );
  }
  setCookie(name: string,value: string){
    this.cookieService.set(name,value);
  }
  getCookie(name: string){
    return this.cookieService.get(name);
  }
  deleteCookie(name: string){
    this.cookieService.delete(name);
  }

}
