import { Component, OnInit } from '@angular/core';
import { CookieService } from 'ngx-cookie-service';
import { GET_REPOS_API } from '../urls';
import { getProjectDetailsResponse } from '../responses';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { Router } from '@angular/router';
import { MatDialog, MatDialogRef} from '@angular/material/dialog';

export interface Tile {
  color: string;
  cols: number;
  rows: number;
  text: string;
}
/**
 * This component renders the home page.
 */
@Component({
  selector: 'app-home',
  templateUrl: './home.component.html',
  styleUrls: ['./home.component.css']
})
export class HomeComponent implements OnInit {
  project_stat$ = new Observable<getProjectDetailsResponse>;
  projects = new Array<{pid:string;pname:string;created_date:string;powner:string;confluence_id:string;git_id:string;jira_id:string;content:string;description:string}>();
  constructor(public dialog:MatDialog, private cookieService: CookieService, private router: Router, private http: HttpClient ) { }
  setCookie(kname: string,value: string){
    this.cookieService.set(kname,value);
  }
  getCookie(kname: string){
    return this.cookieService.get(kname);
  }
  deleteCookie(kname: string){
    this.cookieService.delete(kname);
  }
  /*
  Calculate No of columns for grid
  */
  calColCount(){
    if(window.innerWidth > 1000){
      return 3;
    }else if(window.innerWidth > 600){
      return 2;
    }else{
      return 1;
    }
  }
  /* 
  Opens the Logout DialogBox for Logout Button
  */
  openLogoutDialog(){
    const dialogRef = this.dialog.open(LogoutDialog);
  }
  /*
   * Get the list of Projects the user have access to.
   * If the user does not have access to any project return an alert.
   */
  ngOnInit(): void {
    console.log(this.getCookie('uid'));
    this.project_stat$ = this.http.get<getProjectDetailsResponse>(GET_REPOS_API+'?uid='+ this.getCookie('uid'));
    this.project_stat$.subscribe(
      (response) => {
        console.log(response);
        if (response.status == true) {
          for (let i = 0; i < response.repos.length; i++) {
            this.projects.push(response.repos[i]);
          }
          console.log(this.projects);
        } 
        else{
          alert('No Projects for this User');
        }
      }
    );
  }
  tiles: Tile[] = [
    {text: 'One', cols: 1, rows: 1, color: 'white'},
  ];
}

/**
 * This component is responsible for logout dialog box.
 * If Clicked on cancel it simply closes the dialog.
 * If Clicked on yes, it clears cookie and redirect to login page.
 */
@Component({
  selector: 'logout-dialog',
  templateUrl: './logout-dialog.html',
  styleUrls: ['./home.component.css']
})
export class LogoutDialog{
  constructor(
    public dialogRef: MatDialogRef<LogoutDialog>,
    private cookieService: CookieService,
    private router: Router
  ){

  }

  onCancelClick(){
    this.dialogRef.close();
  }
  onLogoutClick(){
    this.cookieService.deleteAll();
    this.router.navigate(['/login']);
    this.dialogRef.close();
  }
}