import { Component, OnInit } from '@angular/core';
import {Observable, Observer} from 'rxjs';
import { FetcherService } from '../fetcher.service';
import { GET_CONFLUENCE_PAGES_API } from '../urls';
import { getConfluencePagesResponse } from '../responses';
import { HttpClient } from '@angular/common/http';
import { Router } from '@angular/router';
import { CookieService } from 'ngx-cookie-service';

@Component({
  selector: 'app-confluence',
  templateUrl: './confluence.component.html',
  styleUrls: ['./confluence.component.css']
})
export class ConfluenceComponent implements OnInit {
  projectId = "";
  file = "";
  conf_stat$ = new Observable<getConfluencePagesResponse>();
  constructor(private fetcherService: FetcherService, private router: Router, private cookieService: CookieService, private http:HttpClient) { }

  ngOnInit(): void {
    this.projectId = this.cookieService.get('pid');
    this.conf_stat$ = this.http.get<getConfluencePagesResponse>(GET_CONFLUENCE_PAGES_API+'?pid='+this.projectId);
    this.conf_stat$.subscribe((data) => {
      console.log(data);
      if(data.status=true){
        console.log(data);
        this.http.get('assets/'+data.pages,{responseType: 'text'}).subscribe((data_new) => {
          console.log(data_new);
          this.file = data_new;
        }); 
      }
      else{
        console.log("error");
      }
    });
  }
}
