import imp
from django.urls import include,path
from rest_framework import routers

from .views import *
router = routers.DefaultRouter()
router.register(r'users',UserViewSet)
router.register(r'projects',ProjectViewSet)
router.register(r'access',AccessViewSet)
router.register(r'jira',JiraViewSet)
#router.register(r'isAuthenticated',checkAuthViewSet)

urlpatterns = [
    path('',include(router.urls)),
    path('isAuthenticated/',checkAuthViewSet.as_view()),
    path('authenticate/',authenticateViewSet.as_view()),
    path('register/',registerViewSet.as_view()),
    path('getRepos/',getReposViewSet.as_view()),
    path('getGitFiles/',getGitFilesViewSet.as_view()),
    path('getJiraTickets/',getJiraTicketsViewSet.as_view()),
    path('getJiraBoards/',getJiraBoardViewSet.as_view()),
    path('createJiraTicket/',createJiraTicketViewSet.as_view()),
    path('updateJiraTicket/',updateJiraTicketViewSet.as_view()),
    path('postFileChange/',postFileChangeViewSet.as_view()),
    path('postFileCreate/',postFileCreateViewSet.as_view()),
    path('getConfluencePages/',getConfluencePagesViewSet.as_view()),
    path('getUserDetails/',getUserDetailsViewSet.as_view()),
    path('postUserDetails/',postUserDetailsViewSet.as_view()),
    path('getProjectDetails/',getProjectDetailsViewSet.as_view()),
    path('api-auth/',include('rest_framework.urls'))
]
