import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import {Observable, Observer} from 'rxjs';
import { GithubComponent } from '../github/github.component';
import { JiraComponent } from '../jira/jira.component';
import { SlackComponent } from '../slack/slack.component';
import { ConfluenceComponent } from '../confluence/confluence.component';
import { FetcherService } from '../fetcher.service';
export interface ExampleTab {
  label: string;
  content: string;
}

@Component({
  selector: 'app-project',
  templateUrl: './project.component.html',
  styleUrls: ['./project.component.css']
})
export class ProjectComponent implements OnInit {
  id: number;
  name: string;
  tabInd = 1;
  asyncTabs: Observable<ExampleTab[]>;
  constructor(private fetcherService: FetcherService) {
    console.log(window.history.state);
    this.id = window.history.state.id;
    this.name = window.history.state.name;
    this.asyncTabs = new Observable((observer: Observer<ExampleTab[]>) => {
      setTimeout(() => {
        observer.next([
          {label: 'Github', content: 'Content 1'},
          {label: 'Confluence', content: 'Content 2'},
          {label: 'JIRA', content: 'Content 3'},
          {label: 'Slack', content: 'Content 4'}
        ]);
      }, 1000);
    });
  }
  changeTab(event: any) {
    this.tabInd = event.index+1;
  }
  ngOnInit(): void {
    this.fetcherService.setCurrentProjectId(this.id);
  }

}
