import { Component, OnInit } from '@angular/core';
import { FormControl, Validators } from '@angular/forms';
import { CookieService } from 'ngx-cookie-service';
@Component({
  selector: 'app-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.css']
})
export class LoginComponent implements OnInit {
  email = new FormControl('', [Validators.required, Validators.email]);
  password = new FormControl('', [Validators.required]);
  getErrorMessage() {
    if (this.email.hasError('required')) {
      return 'You must enter a value';
    }
    return this.email.hasError('email') ? 'Not a valid email' : '';
  }
  constructor(private cookieService: CookieService) {
    
  }
  login() {
    console.log(this.email.value);
    console.log(this.password.value);
    this.setCookie('email',String(this.email.value));
    this.setCookie('password',String(this.password.value));
    this.setCookie('login','true');

  }
  gotoRegister() {
    console.log('gotoRegister');
  }
  register(){
    console.log(this.email.value);
    console.log(this.password.value);
    this.setCookie('email',String(this.email.value));
    this.setCookie('password',String(this.password.value));
    this.setCookie('login','true');
  }
  setCookie(name: string,value: string){
    this.cookieService.set(name,value);
  }
  getCookie(name: string){
    return this.cookieService.get(name);
  }
  deleteCookie(name: string){
    this.cookieService.delete(name);
  }

  ngOnInit(): void {
  }

}
