import { Component, OnInit } from '@angular/core';
import { CookieService } from 'ngx-cookie-service';
import { PROJECTS } from './projects';
export interface Tile {
  color: string;
  cols: number;
  rows: number;
  text: string;
}
@Component({
  selector: 'app-home',
  templateUrl: './home.component.html',
  styleUrls: ['./home.component.css']
})
export class HomeComponent implements OnInit {
  constructor(private cookieService: CookieService) { }
  setCookie(name: string,value: string){
    this.cookieService.set(name,value);
  }
  getCookie(name: string){
    return this.cookieService.get(name);
  }
  deleteCookie(name: string){
    this.cookieService.delete(name);
  }
  calColCount(){
    console.log(window.innerWidth);
    if(window.innerWidth > 1000){
      return 3;
    }else if(window.innerWidth > 600){
      return 2;
    }else{
      return 1;
    }
  }
  ngOnInit(): void {
  }
  tiles: Tile[] = [
    {text: 'One', cols: 1, rows: 1, color: 'white'},
  ];
  projects = PROJECTS;
}
