import { Component } from '@angular/core';
import { CookieService } from 'ngx-cookie-service';
@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
  private cookieName = 'default';
  private all_cookies:any=''
  title = 'Sitcomm';
  inst = this;
  constructor(private cookieService: CookieService) {
  }
  setCookie(name: string,value: string){
    this.cookieService.set(name,value);
  }
  getCookie(name: string){
    return this.cookieService.get(name);
  }
  deleteCookie(name: string){
    this.cookieService.delete(name);
  }
  getAllCookies(){
    this.all_cookies = this.cookieService.getAll();
  }
  ngOnInit(): void {
    this.setCookie(this.cookieName,'test');
    this.getCookie(this.cookieName);
    this.deleteCookie(this.cookieName);
    this.getAllCookies();
    this.all_cookies = JSON.stringify(this.all_cookies);
  }
}
