from unittest.util import _MAX_LENGTH
from django.db import models
import uuid
# Create your models here.
class Users(models.Model):
    uid = models.UUIDField(primary_key=True,default=uuid.uuid4,editable=False)
    email = models.CharField(max_length=30)
    password = models.CharField(max_length=30)
    role = models.CharField(max_length=30)
    created_date = models.DateTimeField(auto_now_add=True,blank=True)
    active = models.BooleanField(default=False)
    slack_token = models.CharField(max_length=50)
    github_token = models.CharField(max_length=50)
    confluence_token = models.CharField(max_length=50)
    jira_token = models.CharField(max_length=50)

    def __str__(self):
        return f'{self.uid=},{self.email=},{self.password=},{self.role=},{self.created_date=},{self.active=}'

class Projects(models.Model):
    pid = models.UUIDField(primary_key=True,default=uuid.uuid4,editable=False)
    pname = models.CharField(max_length=50)
    created_date = models.DateTimeField(auto_now_add=True,blank=True)
    powner = models.CharField(max_length=50)

    def __str__(self):
        return f'{self.pid=},{self.pname=},{self.created_date=},{self.powner=}'

class Access(models.Model):
    aid = models.UUIDField(primary_key=True,default=uuid.uuid4,editable=False)
    pname = models.CharField(max_length=50)
    pid = models.ForeignKey(Projects,on_delete=models.CASCADE)
    uid = models.ForeignKey(Users,on_delete=models.CASCADE)
    alevel = models.IntegerField(default=0) # 0 = No access 1 = View only 2 = RW 3 = Owner

    def __str__(self):
        return f'{self.aid=},{self.pname=},{self.pid=},{self.uid=},{self.alevel=}'

