from django import views
from django.shortcuts import render
from .models import *
from .serializers import *
from rest_framework import viewsets,views
from rest_framework.response import Response

class UserViewSet(viewsets.ModelViewSet):
    queryset = Users.objects.all()
    serializer_class = UserSerializer

class ProjectViewSet(viewsets.ModelViewSet):
    queryset = Projects.objects.all()
    serializer_class = ProjectSerializer

class AccessViewSet(viewsets.ModelViewSet):
    queryset = Access.objects.all()
    serializer_class = AccessSerializer
# Create your views here.

class checkAuthViewSet(views.APIView):
    def get(self,request):
        uid = request.GET.get('uid')
        try:
            user = Users.objects.get(uid=uid)
            return Response({'status':True})
        except:
            return Response({'status':False})

class authenticateViewSet(views.APIView):
    def post(self,request):
        email = request.data.get('email')
        password = request.data.get('password')
        try:
            user = Users.objects.get(email=email,password=password)
            if user is None:
                return Response({'status':False})
            status = Users.objects.update(email=email,password=password,active=True)
            return Response({'email':email,'status':bool(status)})
        except:
            return Response({'status':False})

class registerViewSet(views.APIView):
    def post(self,request):
        email = request.data.get('email')
        password = request.data.get('password')
        role = request.data.get('role')
        try:
            user = Users.objects.create(email=email,password=password,role=role,active=True)
            return Response({'uid':user.uid,'status':True})
        except:
            return Response({'status':False})