from flask import Flask, flash, request, redirect, url_for, render_template
import urllib.request
from werkzeug.utils import secure_filename
from fileinput import filename
import pandas as pd
import numpy as np
import os
import glob
import matplotlib
matplotlib.use('Agg')
import matplotlib.pyplot as plt


def read_all_csv(path='./rawdata_csv/', extension='csv'):
    result = glob.glob(path+'SRC_R*.{}'.format(extension))
    df=None
    
    for file in result:
        if(df is None):
            df=pd.read_csv(file)
        else:
            df=pd.concat([df,pd.read_csv(file)], ignore_index=True)
    
    df_master=pd.read_csv("SRC_MasterData.csv")
    df_master=df_master[['State_Code','State_Name','Total_Population']]
    final_df = pd.merge(df, df_master, on='State_Code', how='inner')
    final_df['total']=final_df[['Primary_Only','Primary_with_Upper_Primary','Primary with_Upper_Primary_Sec_H.Sec','Upper_Primary_Only','Upper_Primary_with_Sec_H.Sec','Primary_with_Upper_Primary_Sec','Upper_Primary_with_Sec']].sum(axis=1)
    final_df['total_by_population']=final_df['total']/final_df['Total_Population']
    final_df=final_df[["Year","State_Name","State_Code","Main_Dimension","Sub_Dimension","Total_Population",'total','total_by_population']]

    return final_df

final_df=read_all_csv()
latest_year = max(final_df['Year'])

dict_summary={"top3":[],"bottom3":[]}
form_value_to_sub_dimension_mapping = {
    'govt':'Government',
    'private':'Private',
    'others':'Madrasas & Unrecognised',
    'below_secondary':'Below Secondary',
    'secondary':'Secondary',
    'higher_secondary':'Higher Secondary',
    'graduate':'Graduate',
    'post_graduate':'Post Graduate',
    'mphil_phd':'M.Phil / Ph.D',
    'post_doctorate':'Post Doctorate',
    'no_response':'No Response',
    'good':'Good Condition',
    'major':'Need Major Repair',
    'minor':'Need Minor Repair'
}
# fig_size_w=16
# fig_size_h=13

fig_size_w, fig_size_h = 8, 6

def state_total_enrollments(main_df, year, file_name):
    df_filtered=main_df.loc[(main_df['Main_Dimension'] == "Elementary Enrolment by School Category")]
    df_filtered=df_filtered.loc[df_filtered['Year'] == year]
    df_filtered=df_filtered[['Year','State_Name','total','total_by_population']]
    df_sum = df_filtered.groupby(['State_Name','Year'],as_index = False).sum().sort_values("total_by_population",ascending=False)
    
    fig = plt.figure(figsize=(fig_size_w,fig_size_h))
    plt.xticks(rotation=90, ha="right")
    plt.bar(df_sum['State_Name'],df_sum['total_by_population'], align='center')
    plt.ylabel('Enrollements/population')
    list_states=list(df_sum['State_Name'])
    dict_summary['top3']=[list_states[0],list_states[1],list_states[2]]
    dict_summary['bottom3']=[list_states[-1],list_states[-2],list_states[-3]]
    plt.savefig(file_name)
    plt.close(fig)
    
    return dict_summary

# state_total_enrollments(final_df,2010,"enrol")

def statewise_distribution(output_filename, input_df, year, main_dimension, sub_dimension=''):
    # main_dimension = "Elementary Enrolment by School Category"
    if sub_dimension:
        df_filtered = input_df.loc[(input_df['Main_Dimension'] == main_dimension) & ((input_df['Sub_Dimension'] == sub_dimension))]
    else:
        df_filtered = input_df.loc[(input_df['Main_Dimension'] == main_dimension)]
    df_filtered = df_filtered.loc[df_filtered['Year'] == year]
    # print(df_filtered)
    df_filtered = df_filtered[['Year','State_Name','total','total_by_population']]
    df_sum = df_filtered.groupby(['State_Name','Year'],as_index = False).sum().sort_values("total_by_population",ascending=False)
    # print(df_sum)
    fig = plt.figure(figsize=(fig_size_w,fig_size_h))
    plt.xticks(rotation=90, ha="right")
    plt.bar(df_sum['State_Name'],df_sum['total_by_population'], align='center')
    plt.ylabel('Enrollements/Population')
    list_states=list(df_sum['State_Name'])
    # print(list_states)
    dict_summary['top3']=[list_states[0],list_states[1],list_states[2]]
    dict_summary['bottom3']=[list_states[-1],list_states[-2],list_states[-3]]
    plt.savefig(output_filename)
    plt.close(fig)
    
    return dict_summary

# statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], "img/distribution_rural_enrolment.jpeg"), final_df, latest_year, main_dimension = "Rural Elementary Enrolment")
# statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], "img/distribution_rural_enrolment.jpeg"), final_df, latest_year, main_dimension = "Rural Elementary Enrolment", sub_dimension="Government")


def state_total_enrollments_by_rural(main_df, year, file_name):
    df_fil=main_df.loc[(main_df['Main_Dimension'] == "Rural Elementary Enrolment")]
    df_fil=df_fil.loc[df_fil['Year'] == year]
    df_fil=df_fil[['Year','State_Name','total','total_by_population']]
    df_sum = df_fil.groupby(['State_Name','Year'],as_index = False).sum().sort_values("total_by_population",ascending=False)
    
    fig = plt.figure(figsize=(fig_size_w,fig_size_h))
    plt.xticks(rotation=90, ha="right")
    plt.bar(df_sum['State_Name'],df_sum['total_by_population'], align='center')
    plt.ylabel('Enrollements/population')
    list_states=list(df_sum['State_Name'])
    dict_summary['top3']=[list_states[0],list_states[1],list_states[2]]
    dict_summary['bottom3']=[list_states[-1],list_states[-2],list_states[-3]]
    plt.savefig(file_name)
    plt.close(fig)

    return df_sum

# state_total_enrollments(final_df,2010,"enrol")

app = Flask(__name__)
print(' ------------ Server Started ------------ ')
UPLOAD_FOLDER = 'static/'
 
app.secret_key = "secret key"
app.config['UPLOAD_FOLDER'] = UPLOAD_FOLDER
app.config["CACHE_TYPE"] = "null"
app.config['SEND_FILE_MAX_AGE_DEFAULT'] = 0

# app.config['MAX_CONTENT_LENGTH'] = 16 * 1024 * 1024
 
# ALLOWED_EXTENSIONS = set(['png', 'jpg', 'jpeg', 'gif'])
 
# def allowed_file(filename):
#     return '.' in filename and filename.rsplit('.', 1)[1].lower() in ALLOWED_EXTENSIONS

def prepare_graph(filename):
    data=list(np.random.uniform(1, 10, size=(10,1)).reshape(-1))
    ind = np.arange(len(data))
#     plt.ioff()
    fig = plt.figure(figsize=(8,6))
    plt.plot(data, label='Number of Schools', ls='--', color='black', marker='o', markersize=9, mew=2, linewidth=2)
    plt.xlabel('Year')
    plt.ylabel('Number of Schools')
    plt.xticks(ind, [2000+i for i in ind])
    plt.legend(loc=0)
    plt.savefig('./static/'+filename)
    plt.close(fig)

@app.after_request
def add_header(request):
    """
    Add headers to both force latest IE rendering engine or Chrome Frame,
    and also to cache the rendered page for 10 minutes.
    """
    request.headers["Cache-Control"] = "no-cache, no-store, must-revalidate"
    request.headers["Pragma"] = "no-cache"
    request.headers["Expires"] = "0"
    request.headers['Cache-Control'] = 'public, max-age=0'
    return request
    
@app.route('/')
def home():
    return render_template('index.html')

@app.route('/index.html')
def index():
    return render_template('index.html')

distribution_rural_enrolment = ''
distribution_elementary_enrolment = ''
rural_enrolment_summary = {}
elementary_enrolment_summary = {}
rural_enrolment_category = ''
elementary_enrolment_category = ''
@app.route('/students.html')
def students():
    global distribution_elementary_enrolment, distribution_rural_enrolment, rural_enrolment_summary, elementary_enrolment_summary, rural_enrolment_category, elementary_enrolment_category
    elementary_enrolment_category, rural_enrolment_category = 'Government', 'Government' 
    distribution_rural_enrolment = "img/distribution_rural_enrolment_govt_{}.jpeg".format(latest_year)
    rural_enrolment_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_rural_enrolment), final_df, latest_year, main_dimension = "Rural Elementary Enrolment", sub_dimension=elementary_enrolment_category)
    distribution_elementary_enrolment = "img/distribution_elementary_enrolment_govt_{}.jpeg".format(latest_year)
    elementary_enrolment_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_elementary_enrolment), final_df, latest_year, main_dimension = "Elementary Enrolment by School Category", sub_dimension=rural_enrolment_category)
    return render_template('students.html', distribution_rural_enrolment=distribution_rural_enrolment, distribution_elementary_enrolment=distribution_elementary_enrolment, rural_enrolment_summary=rural_enrolment_summary, elementary_enrolment_summary=elementary_enrolment_summary, rural_enrolment_category=rural_enrolment_category, elementary_enrolment_category=elementary_enrolment_category)

distribution_teachers_by_category = ''
distribution_teachers_by_educational_qualification = ''
teachers_by_category_summary = {}
teachers_by_educational_qualification_summary = {}
teachers_category = ''
teachers_qualification = ''
@app.route('/teachers.html')
def teachers():
    global distribution_teachers_by_educational_qualification, distribution_teachers_by_category, teachers_by_category_summary, teachers_by_educational_qualification_summary, teachers_category, teachers_qualification
    teachers_category, teachers_qualification = 'Government', 'Below Secondary' 
    distribution_teachers_by_category = "img/distribution_teachers_by_category_govt_{}.jpeg".format(latest_year)
    teachers_by_category_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_teachers_by_category), final_df, latest_year, main_dimension = "Teachers by School Category", sub_dimension=teachers_category)
    distribution_teachers_by_educational_qualification = "img/distribution_teachers_by_educational_qualification_below_secondary_{}.jpeg".format(latest_year)
    teachers_by_educational_qualification_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_teachers_by_educational_qualification), final_df, latest_year, main_dimension = "Teachers by Educational Qualification", sub_dimension=teachers_qualification)
    return render_template('teachers.html', distribution_teachers_by_category=distribution_teachers_by_category, distribution_teachers_by_educational_qualification=distribution_teachers_by_educational_qualification, teachers_by_category_summary=teachers_by_category_summary, teachers_by_educational_qualification_summary=teachers_by_educational_qualification_summary, teachers_category=teachers_category, teachers_qualification=teachers_qualification)

@app.route('/schools.html')
def schools():
    return render_template('schools.html')

distribution_classroom_by_condition = ''
classroom_condition_summary = {}
classroom_condition = ''
@app.route('/classrooms.html')
def classrooms():
    global distribution_classroom_by_condition, classroom_condition_summary, classroom_condition
    classroom_condition = 'Good Condition'
    distribution_classroom_by_condition = "img/distribution_classroom_by_condition_good_{}.jpeg".format(latest_year)
    classroom_condition_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_classroom_by_condition), final_df, latest_year, main_dimension = "Total Classrooms", sub_dimension=classroom_condition)
    return render_template('classrooms.html', distribution_classroom_by_condition=distribution_classroom_by_condition, classroom_condition_summary=classroom_condition_summary,  classroom_condition=classroom_condition)

@app.route('/facilities.html')
def facilities():
    return render_template('facilities.html')

# display selected image
@app.route('/get_card_from_index', methods=['POST'])
def get_card_from_index():    
    card_from_index = 'img/sample_trend_schools.jpeg'
    prepare_graph(card_from_index)
    return render_template('index.html', card_from_index=card_from_index)

@app.route('/get_facilities_from_index', methods=['POST'])
def get_facilities_from_index():    
    facilities_from_index = 'img/sample_trend_facilities.jpeg'
    prepare_graph(facilities_from_index)
    return render_template('index.html', facilities_from_index=facilities_from_index)

@app.route('/get_trend_from_students', methods=['POST'])
def get_trend_from_students():
    trend_from_students = 'img/sample_trend_students_new.jpeg'
    prepare_graph(trend_from_students)
    return render_template('students.html', trend_from_students=trend_from_students)

@app.route('/get_distribution_for_elementary_enrolment', methods=['POST'])
def get_distribution_for_elementary_enrolment():
    global form_value_to_sub_dimension_mapping, distribution_elementary_enrolment, distribution_rural_enrolment, elementary_enrolment_summary, rural_enrolment_summary, elementary_enrolment_category, rural_enrolment_category
    elementary_enrolment_category = form_value_to_sub_dimension_mapping[request.form['category']]
    requested_year = int(request.form['year'])
    distribution_elementary_enrolment = "img/distribution_elementary_enrolment_{}_{}.jpeg".format(request.form['category'], requested_year)
    elementary_enrolment_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_elementary_enrolment), final_df, requested_year, main_dimension = "Elementary Enrolment by School Category", sub_dimension=elementary_enrolment_category)
    return render_template('students.html', distribution_rural_enrolment=distribution_rural_enrolment, distribution_elementary_enrolment=distribution_elementary_enrolment, rural_enrolment_summary=rural_enrolment_summary, elementary_enrolment_summary=elementary_enrolment_summary, rural_enrolment_category=rural_enrolment_category, elementary_enrolment_category=elementary_enrolment_category)

@app.route('/get_distribution_for_rural_enrolment', methods=['POST'])
def get_distribution_for_rural_enrolment():
    global form_value_to_sub_dimension_mapping, distribution_elementary_enrolment, distribution_rural_enrolment, elementary_enrolment_summary, rural_enrolment_summary, elementary_enrolment_category, rural_enrolment_category
    rural_enrolment_category = form_value_to_sub_dimension_mapping[request.form['category']]
    requested_year = int(request.form['year'])
    distribution_rural_enrolment = "img/distribution_elementary_enrolment_{}_{}.jpeg".format(request.form['category'], requested_year)
    rural_enrolment_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_rural_enrolment), final_df, requested_year, main_dimension = "Elementary Enrolment by School Category", sub_dimension=rural_enrolment_category)
    return render_template('students.html', distribution_rural_enrolment=distribution_rural_enrolment, distribution_elementary_enrolment=distribution_elementary_enrolment, rural_enrolment_summary=rural_enrolment_summary, elementary_enrolment_summary=elementary_enrolment_summary, rural_enrolment_category=rural_enrolment_category, elementary_enrolment_category=elementary_enrolment_category)

@app.route('/get_distribution_for_teachers_by_category', methods=['POST'])
def get_distribution_for_teachers_by_category():
    global distribution_teachers_by_educational_qualification, distribution_teachers_by_category, teachers_by_category_summary, teachers_by_educational_qualification_summary, teachers_category, teachers_qualification
    teachers_category = form_value_to_sub_dimension_mapping[request.form['category']]
    requested_year = int(request.form['year'])
    distribution_teachers_by_category = "img/distribution_teachers_by_category_govt_{}.jpeg".format(requested_year)
    teachers_by_category_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_teachers_by_category), final_df, requested_year, main_dimension = "Teachers by School Category", sub_dimension=teachers_category)
    return render_template('teachers.html', distribution_teachers_by_category=distribution_teachers_by_category, distribution_teachers_by_educational_qualification=distribution_teachers_by_educational_qualification, teachers_by_category_summary=teachers_by_category_summary, teachers_by_educational_qualification_summary=teachers_by_educational_qualification_summary, teachers_category=teachers_category, teachers_qualification=teachers_qualification)

@app.route('/get_distribution_for_teachers_by_educational_qualification', methods=['POST'])
def get_distribution_for_teachers_by_educational_qualification():
    global distribution_teachers_by_educational_qualification, distribution_teachers_by_category, teachers_by_category_summary, teachers_by_educational_qualification_summary, teachers_category, teachers_qualification
    teachers_qualification = form_value_to_sub_dimension_mapping[request.form['qualification']]
    requested_year = int(request.form['year'])
    distribution_teachers_by_educational_qualification = "img/distribution_teachers_by_educational_qualification_below_secondary_{}.jpeg".format(requested_year)
    teachers_by_educational_qualification_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_teachers_by_educational_qualification), final_df, requested_year, main_dimension = "Teachers by Educational Qualification", sub_dimension=teachers_qualification)
    return render_template('teachers.html', distribution_teachers_by_category=distribution_teachers_by_category, distribution_teachers_by_educational_qualification=distribution_teachers_by_educational_qualification, teachers_by_category_summary=teachers_by_category_summary, teachers_by_educational_qualification_summary=teachers_by_educational_qualification_summary, teachers_category=teachers_category, teachers_qualification=teachers_qualification)

@app.route('/get_trend_from_schools', methods=['POST'])
def get_trend_from_schools():
    trend_from_schools = 'img/sample_trend_schools_new.jpeg'
    prepare_graph(trend_from_schools)
    return render_template('schools.html', trend_from_schools=trend_from_schools)

@app.route('/get_distribution_from_schools', methods=['POST'])
def get_distribution_from_schools():
    distribution_from_schools = 'img/sample_distribution_schools_new.jpeg'
    prepare_graph(distribution_from_schools)
    return render_template('schools.html', distribution_from_schools=distribution_from_schools)

@app.route('/get_trend_from_classrooms', methods=['POST'])
def get_trend_from_classrooms():
    trend_from_classrooms = 'img/sample_trend_classrooms_new.jpeg'
    prepare_graph(trend_from_classrooms)
    return render_template('classrooms.html', trend_from_classrooms=trend_from_classrooms)

@app.route('/get_distribution_of_classroom_conditions', methods=['POST'])
def get_distribution_of_classroom_conditions():
    global distribution_classroom_by_condition, classroom_condition_summary, classroom_condition
    classroom_condition = form_value_to_sub_dimension_mapping[request.form['condition']]
    requested_year = int(request.form['year'])
    distribution_classroom_by_condition = "img/distribution_classroom_by_condition_{}_{}.jpeg".format(request.form['condition'], requested_year)
    classroom_condition_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_classroom_by_condition), final_df, latest_year, main_dimension = "Total Classrooms", sub_dimension=classroom_condition)
    return render_template('classrooms.html', distribution_classroom_by_condition=distribution_classroom_by_condition, classroom_condition_summary=classroom_condition_summary,  classroom_condition=classroom_condition)

@app.route('/get_trend_from_facilities', methods=['POST'])
def get_trend_from_facilities():
    trend_from_facilities = 'img/sample_trend_facilities_new.jpeg'
    prepare_graph(trend_from_facilities)
    return render_template('facilities.html', trend_from_facilities=trend_from_facilities)

@app.route('/get_distribution_from_facilities', methods=['POST'])
def get_distribution_from_facilities():
    distribution_from_facilities = 'img/sample_distribution_facilities_new.jpeg'
    prepare_graph(distribution_from_facilities)
    return render_template('facilities.html', distribution_from_facilities=distribution_from_facilities)

# # @app.route('/display/<filename>')
# @app.route('/display/<filename>')
# def display_image(filename):
#     pass
# #     print('display_image filename: ' + filename)
#     return redirect(url_for('static', filename=filename), code=301)


if __name__ == "__main__":
    app.run()