from flask import Flask, flash, request, redirect, url_for, render_template
import pandas as pd
import numpy as np
import os
import glob
from utils import *
import matplotlib
matplotlib.use('Agg')
import matplotlib.pyplot as plt
# import config,py
from config import *

final_df=read_all_csv()
latest_year = max(final_df['Year'])

app = Flask(__name__)
print(' ------------ Server Started ------------ ')
UPLOAD_FOLDER = 'static/'
 
# app.secret_key = "secret key"
app.config['UPLOAD_FOLDER'] = UPLOAD_FOLDER
# app.config["CACHE_TYPE"] = "null"
# app.config['SEND_FILE_MAX_AGE_DEFAULT'] = 0

@app.after_request
def add_header(request):
    request.headers["Cache-Control"] = "no-cache, no-store, must-revalidate"
    request.headers["Pragma"] = "no-cache"
    request.headers["Expires"] = "0"
    request.headers['Cache-Control'] = 'public, max-age=0'
    return request

# routes for index.html
main_dimension_from_index = ''
facilities_from_index = "img/trend_school_facilities_index.jpeg"
index_summary = get_index_summary(final_df)
@app.route('/')
def home():
    global index_summary, main_dimension_from_index, facilities_from_index
    main_dimension_from_index = "img/trend_enrolments_index.jpeg"
    main_dimension_overall(os.path.join(app.config['UPLOAD_FOLDER'], main_dimension_from_index), final_df, main_dimension="Elementary Enrolment by School Category", ylabel="Enrolments")
    total_schools_for_facilities_overall(os.path.join(app.config['UPLOAD_FOLDER'], facilities_from_index), final_df)
    return render_template('index.html', index_summary=index_summary, main_dimension_index="Elementary Enrolment by School Category", main_dimension_from_index=main_dimension_from_index, facilities_from_index=facilities_from_index)

@app.route('/index.html')
def index():
    global index_summary, main_dimension_from_index, facilities_from_index
    main_dimension_from_index = "img/trend_enrolments_index.jpeg"
    main_dimension_overall(os.path.join(app.config['UPLOAD_FOLDER'], main_dimension_from_index), final_df, main_dimension="Elementary Enrolment by School Category", ylabel="Enrolments")
    total_schools_for_facilities_overall(os.path.join(app.config['UPLOAD_FOLDER'], facilities_from_index), final_df)
    return render_template('index.html', index_summary=index_summary, main_dimension_index="Elementary Enrolment by School Category", main_dimension_from_index=main_dimension_from_index, facilities_from_index=facilities_from_index)

@app.route('/get_main_dimension_from_index', methods=['POST'])
def get_main_dimension_from_index():   
    global index_summary, main_dimension_mapping_for_index, main_dimension_from_index, facilities_from_index
    main_dimension_tuple = main_dimension_mapping_for_index[request.form['dimension']]
    main_dimension_from_index = "img/trend_{}_index.jpeg".format(request.form['dimension'])
    main_dimension_overall(os.path.join(app.config['UPLOAD_FOLDER'], main_dimension_from_index), final_df, main_dimension_tuple[0], ylabel=main_dimension_tuple[1])
    return render_template('index.html', index_summary=index_summary, main_dimension_index=main_dimension_tuple[0] , main_dimension_from_index=main_dimension_from_index, facilities_from_index=facilities_from_index)

# routes for students.html
students_summary = {}
trend_elementary_enrolment = ''
distribution_rural_enrolment = ''
distribution_elementary_enrolment = ''
rural_enrolment_summary = {}
elementary_enrolment_summary = {}
rural_enrolment_category = ''
elementary_enrolment_category = ''
@app.route('/students.html')
def students():
    global students_summary, trend_elementary_enrolment, distribution_elementary_enrolment, distribution_rural_enrolment, rural_enrolment_summary, elementary_enrolment_summary, rural_enrolment_category, elementary_enrolment_category
    elementary_enrolment_category, rural_enrolment_category = 'Government', 'Government' 
    distribution_rural_enrolment = "img/distribution_rural_enrolment_govt_{}.jpeg".format(latest_year)
    rural_enrolment_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_rural_enrolment), final_df, latest_year, ylabel="Enrolments / Population", main_dimension = "Rural Elementary Enrolment", sub_dimension=elementary_enrolment_category)
    distribution_elementary_enrolment = "img/distribution_elementary_enrolment_govt_{}.jpeg".format(latest_year)
    elementary_enrolment_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_elementary_enrolment), final_df, latest_year, ylabel="Enrolments / Population", main_dimension = "Elementary Enrolment by School Category", sub_dimension=rural_enrolment_category)
    trend_elementary_enrolment = "img/trend_elementary_enrolment_category_{}.jpeg".format(default_state_code)
    total_enrolment_by_category(os.path.join(app.config['UPLOAD_FOLDER'], trend_elementary_enrolment), final_df, main_dimension='Elementary Enrolment by School Category', state_code=default_state_code, ylabel='Enrolments')
    students_summary = get_dimension_wise_summary(final_df, default_state_code, "Elementary Enrolment by School Category")
    return render_template('students.html', students_summary=students_summary, trend_elementary_enrolment=trend_elementary_enrolment, distribution_rural_enrolment=distribution_rural_enrolment, distribution_elementary_enrolment=distribution_elementary_enrolment, rural_enrolment_summary=rural_enrolment_summary, elementary_enrolment_summary=elementary_enrolment_summary, rural_enrolment_category=rural_enrolment_category, elementary_enrolment_category=elementary_enrolment_category)

@app.route('/get_trend_for_elementary_enrolment', methods=['POST'])
def get_trend_for_elementary_enrolment():
    global students_summary, form_value_to_main_dimension_mapping, trend_elementary_enrolment, distribution_elementary_enrolment, distribution_rural_enrolment, rural_enrolment_summary, elementary_enrolment_summary, rural_enrolment_category, elementary_enrolment_category
    main_dimension = form_value_to_main_dimension_mapping[request.form['type']]
    state_code = int(request.form['state_code'])
    trend_elementary_enrolment = "img/trend_{}_{}.jpeg".format(request.form['type'],state_code)
    total_enrolment_by_category(os.path.join(app.config['UPLOAD_FOLDER'], trend_elementary_enrolment), final_df, main_dimension, state_code, ylabel='Enrolments')
    students_summary = get_dimension_wise_summary(final_df, state_code, "Elementary Enrolment by School Category")
    return render_template('students.html', students_summary=students_summary, trend_elementary_enrolment=trend_elementary_enrolment, distribution_rural_enrolment=distribution_rural_enrolment, distribution_elementary_enrolment=distribution_elementary_enrolment, rural_enrolment_summary=rural_enrolment_summary, elementary_enrolment_summary=elementary_enrolment_summary, rural_enrolment_category=rural_enrolment_category, elementary_enrolment_category=elementary_enrolment_category)

@app.route('/get_distribution_for_elementary_enrolment', methods=['POST'])
def get_distribution_for_elementary_enrolment():
    global students_summary, form_value_to_sub_dimension_mapping, trend_elementary_enrolment, distribution_elementary_enrolment, distribution_rural_enrolment, elementary_enrolment_summary, rural_enrolment_summary, elementary_enrolment_category, rural_enrolment_category
    elementary_enrolment_category = form_value_to_sub_dimension_mapping[request.form['category']]
    requested_year = int(request.form['year'])
    distribution_elementary_enrolment = "img/distribution_elementary_enrolment_{}_{}.jpeg".format(request.form['category'], requested_year)
    elementary_enrolment_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_elementary_enrolment), final_df, requested_year, ylabel="Enrolments / Population", main_dimension = "Elementary Enrolment by School Category", sub_dimension=elementary_enrolment_category)
    return render_template('students.html', students_summary=students_summary, trend_elementary_enrolment=trend_elementary_enrolment, distribution_rural_enrolment=distribution_rural_enrolment, distribution_elementary_enrolment=distribution_elementary_enrolment, rural_enrolment_summary=rural_enrolment_summary, elementary_enrolment_summary=elementary_enrolment_summary, rural_enrolment_category=rural_enrolment_category, elementary_enrolment_category=elementary_enrolment_category)

@app.route('/get_distribution_for_rural_enrolment', methods=['POST'])
def get_distribution_for_rural_enrolment():
    global students_summary, form_value_to_sub_dimension_mapping, trend_elementary_enrolment, distribution_elementary_enrolment, distribution_rural_enrolment, elementary_enrolment_summary, rural_enrolment_summary, elementary_enrolment_category, rural_enrolment_category
    rural_enrolment_category = form_value_to_sub_dimension_mapping[request.form['category']]
    requested_year = int(request.form['year'])
    distribution_rural_enrolment = "img/distribution_elementary_enrolment_{}_{}.jpeg".format(request.form['category'], requested_year)
    rural_enrolment_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_rural_enrolment), final_df, requested_year, ylabel="Enrolments / Population", main_dimension = "Elementary Enrolment by School Category", sub_dimension=rural_enrolment_category)
    return render_template('students.html', students_summary=students_summary, trend_elementary_enrolment=trend_elementary_enrolment, distribution_rural_enrolment=distribution_rural_enrolment, distribution_elementary_enrolment=distribution_elementary_enrolment, rural_enrolment_summary=rural_enrolment_summary, elementary_enrolment_summary=elementary_enrolment_summary, rural_enrolment_category=rural_enrolment_category, elementary_enrolment_category=elementary_enrolment_category)

# routes for teachers.html
teachers_summary = {}
trend_teachers = ''
distribution_teachers_by_category = ''
distribution_teachers_by_educational_qualification = ''
teachers_by_category_summary = {}
teachers_by_educational_qualification_summary = {}
teachers_category = ''
teachers_qualification = ''
@app.route('/teachers.html')
def teachers():
    global teachers_summary, trend_teachers, distribution_teachers_by_educational_qualification, distribution_teachers_by_category, teachers_by_category_summary, teachers_by_educational_qualification_summary, teachers_category, teachers_qualification
    teachers_category, teachers_qualification = 'Government', 'Below Secondary' 
    distribution_teachers_by_category = "img/distribution_teachers_by_category_govt_{}.jpeg".format(latest_year)
    teachers_by_category_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_teachers_by_category), final_df, latest_year, ylabel="Number of Teachers / Population", main_dimension = "Teachers by School Category", sub_dimension=teachers_category)
    distribution_teachers_by_educational_qualification = "img/distribution_teachers_by_educational_qualification_below_secondary_{}.jpeg".format(latest_year)
    teachers_by_educational_qualification_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_teachers_by_educational_qualification), final_df, latest_year, ylabel="Number of Teachers / Population", main_dimension = "Teachers by Educational Qualification", sub_dimension=teachers_qualification)
    trend_teachers="img/trend_teachers_by_category_{}.jpeg".format(default_state_code)
    total_teachers_by_main_dimension(os.path.join(app.config['UPLOAD_FOLDER'], trend_teachers), final_df, "Teachers by School Category", default_state_code)
    teachers_summary = get_dimension_wise_summary(final_df, default_state_code, "Teachers by School Category")
    return render_template('teachers.html', teachers_summary=teachers_summary, trend_teachers=trend_teachers, distribution_teachers_by_category=distribution_teachers_by_category, distribution_teachers_by_educational_qualification=distribution_teachers_by_educational_qualification, teachers_by_category_summary=teachers_by_category_summary, teachers_by_educational_qualification_summary=teachers_by_educational_qualification_summary, teachers_category=teachers_category, teachers_qualification=teachers_qualification)

@app.route('/get_trend_for_teachers', methods=['POST'])
def get_trend_for_teachers():
    global teachers_summary, form_value_to_main_dimension_mapping, trend_teachers, distribution_teachers_by_educational_qualification, distribution_teachers_by_category, teachers_by_category_summary, teachers_by_educational_qualification_summary, teachers_category, teachers_qualification
    main_dimension = form_value_to_main_dimension_mapping[request.form['type']]
    state_code = int(request.form['state_code'])
    trend_teachers="img/trend_{}_{}.jpeg".format(request.form['type'], state_code)
    total_teachers_by_main_dimension(os.path.join(app.config['UPLOAD_FOLDER'], trend_teachers), final_df, main_dimension, state_code)
    teachers_summary = get_dimension_wise_summary(final_df, state_code, "Teachers by School Category")
    return render_template('teachers.html', teachers_summary=teachers_summary, trend_teachers=trend_teachers, distribution_teachers_by_category=distribution_teachers_by_category, distribution_teachers_by_educational_qualification=distribution_teachers_by_educational_qualification, teachers_by_category_summary=teachers_by_category_summary, teachers_by_educational_qualification_summary=teachers_by_educational_qualification_summary, teachers_category=teachers_category, teachers_qualification=teachers_qualification)

@app.route('/get_distribution_for_teachers_by_category', methods=['POST'])
def get_distribution_for_teachers_by_category():
    global teachers_summary, distribution_teachers_by_educational_qualification, trend_teachers, distribution_teachers_by_category, teachers_by_category_summary, teachers_by_educational_qualification_summary, teachers_category, teachers_qualification
    teachers_category = form_value_to_sub_dimension_mapping[request.form['category']]
    requested_year = int(request.form['year'])
    distribution_teachers_by_category = "img/distribution_teachers_by_category_{}_{}.jpeg".format(request.form['category'], requested_year)
    teachers_by_category_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_teachers_by_category), final_df, requested_year,ylabel="Number of Teachers / Population", main_dimension = "Teachers by School Category", sub_dimension=teachers_category)
    return render_template('teachers.html', teachers_summary=teachers_summary, trend_teachers=trend_teachers, distribution_teachers_by_category=distribution_teachers_by_category, distribution_teachers_by_educational_qualification=distribution_teachers_by_educational_qualification, teachers_by_category_summary=teachers_by_category_summary, teachers_by_educational_qualification_summary=teachers_by_educational_qualification_summary, teachers_category=teachers_category, teachers_qualification=teachers_qualification)

@app.route('/get_distribution_for_teachers_by_educational_qualification', methods=['POST'])
def get_distribution_for_teachers_by_educational_qualification():
    global teachers_summary, distribution_teachers_by_educational_qualification, trend_teachers, distribution_teachers_by_category, teachers_by_category_summary, teachers_by_educational_qualification_summary, teachers_category, teachers_qualification
    teachers_qualification = form_value_to_sub_dimension_mapping[request.form['qualification']]
    requested_year = int(request.form['year'])
    distribution_teachers_by_educational_qualification = "img/distribution_teachers_by_educational_qualification_{}_{}.jpeg".format(request.form['qualification'], requested_year)
    teachers_by_educational_qualification_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_teachers_by_educational_qualification), final_df, requested_year, ylabel="Number of Teachers / Population", main_dimension = "Teachers by Educational Qualification", sub_dimension=teachers_qualification)
    return render_template('teachers.html', teachers_summary=teachers_summary, trend_teachers=trend_teachers, distribution_teachers_by_category=distribution_teachers_by_category, distribution_teachers_by_educational_qualification=distribution_teachers_by_educational_qualification, teachers_by_category_summary=teachers_by_category_summary, teachers_by_educational_qualification_summary=teachers_by_educational_qualification_summary, teachers_category=teachers_category, teachers_qualification=teachers_qualification)

# routes for schools.html
schools_summary = {}
trend_schools = ''
distribution_schools_by_category = ''
distribution_rural_schools_by_category = ''
schools_by_category_summary = {}
rural_schools_by_category_summary = {}
school_category = ''
rural_school_category = ''
@app.route('/schools.html')
def schools():
    global schools_summary, trend_schools, distribution_rural_schools_by_category, distribution_schools_by_category, schools_by_category_summary, rural_schools_by_category_summary, school_category, rural_school_category
    school_category, rural_school_category = 'Government', 'Government' 
    distribution_schools_by_category = "img/distribution_schools_by_category_govt_{}.jpeg".format(latest_year)
    schools_by_category_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_schools_by_category), final_df, latest_year, ylabel="Number of Schools / Population", main_dimension = "School by Category", sub_dimension=school_category)
    distribution_rural_schools_by_category = "img/distribution_rural_schools_by_category_below_secondary_{}.jpeg".format(latest_year)
    rural_schools_by_category_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_rural_schools_by_category), final_df, latest_year, ylabel="Number of Schools / Population", main_dimension = "Rural Schools", sub_dimension=rural_school_category)
    trend_schools = "img/trend_schools_category_{}.jpeg".format(default_state_code)
    total_enrolment_by_category(os.path.join(app.config['UPLOAD_FOLDER'], trend_schools), final_df, main_dimension='School by Category', state_code=default_state_code, ylabel='Number of Schools')
    schools_summary = get_dimension_wise_summary(final_df, default_state_code, "School by Category")
    return render_template('schools.html', schools_summary=schools_summary, trend_schools=trend_schools, distribution_schools_by_category=distribution_schools_by_category, distribution_rural_schools_by_category=distribution_rural_schools_by_category, schools_by_category_summary=schools_by_category_summary, rural_schools_by_category_summary=rural_schools_by_category_summary, school_category=school_category, rural_school_category=rural_school_category)

@app.route('/get_trend_for_schools', methods=['POST'])
def get_trend_for_schools():
    global schools_summary, form_value_to_main_dimension_mapping ,trend_schools, distribution_rural_schools_by_category, distribution_schools_by_category, schools_by_category_summary, rural_schools_by_category_summary, school_category, rural_school_category
    main_dimension = form_value_to_main_dimension_mapping[request.form['type']]
    state_code = int(request.form['state_code'])
    trend_schools = "img/trend_{}_{}.jpeg".format(request.form['type'], state_code)
    total_enrolment_by_category(os.path.join(app.config['UPLOAD_FOLDER'], trend_schools), final_df, main_dimension, state_code, ylabel='Number of Schools')
    schools_summary = get_dimension_wise_summary(final_df, state_code, "School by Category")
    return render_template('schools.html', schools_summary=schools_summary, trend_schools=trend_schools, distribution_schools_by_category=distribution_schools_by_category, distribution_rural_schools_by_category=distribution_rural_schools_by_category, schools_by_category_summary=schools_by_category_summary, rural_schools_by_category_summary=rural_schools_by_category_summary, school_category=school_category, rural_school_category=rural_school_category)

@app.route('/get_distribution_of_schools_by_category', methods=['POST'])
def get_distribution_of_schools_by_category():
    global schools_summary, schools_summarydistribution_rural_schools_by_category, trend_schools, distribution_schools_by_category, schools_by_category_summary, rural_schools_by_category_summary, school_category, rural_school_category
    school_category = form_value_to_sub_dimension_mapping[request.form['category']]
    requested_year = int(request.form['year'])
    distribution_schools_by_category = "img/distribution_schools_by_category_{}_{}.jpeg".format(request.form['category'], requested_year)
    schools_by_category_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_schools_by_category), final_df, requested_year, ylabel="Number of Schools / Population", main_dimension = "School by Category", sub_dimension=school_category)
    return render_template('schools.html', schools_summary=schools_summary, trend_schools=trend_schools, distribution_schools_by_category=distribution_schools_by_category, distribution_rural_schools_by_category=distribution_rural_schools_by_category, schools_by_category_summary=schools_by_category_summary, rural_schools_by_category_summary=rural_schools_by_category_summary, school_category=school_category, rural_school_category=rural_school_category)

@app.route('/get_distribution_of_rural_schools_by_category', methods=['POST'])
def get_distribution_of_rural_schools_by_category():
    global schools_summary, distribution_rural_schools_by_category, trend_schools, distribution_schools_by_category, schools_by_category_summary, rural_schools_by_category_summary, school_category, rural_school_category
    rural_school_category = form_value_to_sub_dimension_mapping[request.form['category']]
    requested_year = int(request.form['year'])
    distribution_rural_schools_by_category = "img/distribution_rural_schools_by_category_{}_{}.jpeg".format(request.form['category'], requested_year)
    rural_schools_by_category_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_rural_schools_by_category), final_df, requested_year, ylabel="Number of Schools / Population", main_dimension = "Rural Schools", sub_dimension=rural_school_category)
    return render_template('schools.html', schools_summary=schools_summary, trend_schools=trend_schools, distribution_schools_by_category=distribution_schools_by_category, distribution_rural_schools_by_category=distribution_rural_schools_by_category, schools_by_category_summary=schools_by_category_summary, rural_schools_by_category_summary=rural_schools_by_category_summary, school_category=school_category, rural_school_category=rural_school_category)

# routes for classrooms.html
classrooms_summary = {}
trend_classrooms = ''
distribution_classroom_by_condition = ''
classroom_condition_summary = {}
classroom_condition = ''
@app.route('/classrooms.html')
def classrooms():
    global classrooms_summary, trend_classrooms, distribution_classroom_by_condition, classroom_condition_summary, classroom_condition
    classroom_condition = 'Good Condition'
    distribution_classroom_by_condition = "img/distribution_classroom_by_condition_good_{}.jpeg".format(latest_year)
    classroom_condition_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_classroom_by_condition), final_df, latest_year, ylabel="Number of Classrooms / Population", main_dimension = "Total Classrooms", sub_dimension=classroom_condition)
    trend_classrooms = "img/trend_classrooms_{}.jpeg".format(default_state_code)
    total_classrooms_by_trend(os.path.join(app.config['UPLOAD_FOLDER'], trend_classrooms), final_df, default_state_code)
    classrooms_summary = get_dimension_wise_summary(final_df, default_state_code, "Total Classrooms")
    return render_template('classrooms.html', classrooms_summary=classrooms_summary, trend_classrooms=trend_classrooms, distribution_classroom_by_condition=distribution_classroom_by_condition, classroom_condition_summary=classroom_condition_summary,  classroom_condition=classroom_condition)

@app.route('/get_trend_for_classrooms', methods=['POST'])
def get_trend_for_classrooms():
    global classrooms_summary, form_value_to_main_dimension_mapping, trend_classrooms, distribution_classroom_by_condition, classroom_condition_summary, classroom_condition
    state_code = int(request.form['state_code'])
    trend_classrooms = "img/trend_classrooms_{}.jpeg".format(state_code)
    total_classrooms_by_trend(os.path.join(app.config['UPLOAD_FOLDER'], trend_classrooms), final_df, state_code)
    classrooms_summary = get_dimension_wise_summary(final_df, state_code, "Total Classrooms")
    return render_template('classrooms.html', classrooms_summary=classrooms_summary, trend_classrooms=trend_classrooms, distribution_classroom_by_condition=distribution_classroom_by_condition, classroom_condition_summary=classroom_condition_summary,  classroom_condition=classroom_condition)

@app.route('/get_distribution_of_classroom_conditions', methods=['POST'])
def get_distribution_of_classroom_conditions():
    global classrooms_summary, distribution_classroom_by_condition, trend_classrooms, classroom_condition_summary, classroom_condition
    classroom_condition = form_value_to_sub_dimension_mapping[request.form['condition']]
    requested_year = int(request.form['year'])
    distribution_classroom_by_condition = "img/distribution_classroom_by_condition_{}_{}.jpeg".format(request.form['condition'], requested_year)
    classroom_condition_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_classroom_by_condition), final_df, latest_year, ylabel="Number of Classrooms / Population", main_dimension = "Total Classrooms", sub_dimension=classroom_condition)
    return render_template('classrooms.html', classrooms_summary=classrooms_summary, trend_classrooms=trend_classrooms, distribution_classroom_by_condition=distribution_classroom_by_condition, classroom_condition_summary=classroom_condition_summary,  classroom_condition=classroom_condition)

# routes for facilities.html
facilities_summary = {}
trend_school_facilities = ''
distribution_school_facility = ''
school_facility_summary = {}
school_facility = ''
@app.route('/facilities.html')
def facilities():
    global facilities_summary, trend_school_facilities, distribution_school_facility, school_facility_summary, school_facility
    school_facility = 'Schools with Drinking Water'
    distribution_school_facility = "img/distribution_school_facility_drinking_water_{}.jpeg".format(latest_year)
    school_facility_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_school_facility), final_df, latest_year, ylabel="Number of Schools / Population", main_dimension = "School Facilities", sub_dimension=school_facility)
    trend_school_facilities = "img/trend_school_facilities_{}.jpeg".format(default_state_code)
    total_schools_for_facilities(os.path.join(app.config['UPLOAD_FOLDER'], trend_school_facilities), final_df, default_state_code)
    facilities_summary = get_dimension_wise_summary(final_df, default_state_code, "School Facilities")
    return render_template('facilities.html', facilities_summary=facilities_summary, trend_school_facilities=trend_school_facilities, distribution_school_facility=distribution_school_facility, school_facility_summary=school_facility_summary,  school_facility=school_facility)

@app.route('/get_trend_for_schools_with_facilities', methods=['POST'])
def get_trend_for_schools_with_facilities():
    global facilities_summary, form_value_to_main_dimension_mapping, trend_school_facilities, distribution_school_facility, school_facility_summary, school_facility
    state_code = int(request.form['state_code'])
    trend_school_facilities = "img/trend_school_facilities_{}.jpeg".format(state_code)
    total_schools_for_facilities(os.path.join(app.config['UPLOAD_FOLDER'], trend_school_facilities), final_df, state_code)
    facilities_summary = get_dimension_wise_summary(final_df, state_code, "School Facilities")
    return render_template('facilities.html', facilities_summary=facilities_summary, trend_school_facilities=trend_school_facilities, distribution_school_facility=distribution_school_facility, school_facility_summary=school_facility_summary,  school_facility=school_facility)

@app.route('/get_distribution_of_school_facilities', methods=['POST'])
def get_distribution_of_school_facilities():
    global facilities_summary, distribution_school_facility, trend_school_facilities, school_facility_summary, school_facility
    school_facility = form_value_to_sub_dimension_mapping[request.form['facility']]
    requested_year = int(request.form['year'])
    distribution_school_facility = "img/distribution_school_facility_{}_{}.jpeg".format(request.form['facility'], requested_year)
    school_facility_summary = statewise_distribution(os.path.join(app.config['UPLOAD_FOLDER'], distribution_school_facility), final_df, latest_year, ylabel="Number of Schools / Population", main_dimension = "School Facilities", sub_dimension=school_facility)
    return render_template('facilities.html', facilities_summary=facilities_summary, trend_school_facilities=trend_school_facilities, distribution_school_facility=distribution_school_facility, school_facility_summary=school_facility_summary,  school_facility=school_facility)

if __name__ == "__main__":
    app.run()