var http = require('http');
var fs = require('fs');

var download = function (url, dest, cb) {
    return new Promise((resolve, reject) => {
        var file = fs.createWriteStream(dest);
        var request = http.get(url, function (response) {
            response.pipe(file);
            file.on('finish', function () {
                file.close(cb);  // close() is async, call cb after close completes.
                resolve();
            });
        }).on('error', function (err) { // Handle errors
            fs.unlink(dest); // Delete the file async. (But we don't check the result)
            if (cb) cb(err.message);
            reject(err);
        });
    })
    
};

module.exports.download = download