const mqtt = require('mqtt')
const client = mqtt.connect('mqtt://localhost')
const libSupport = require('./lib')
const execute = require('./execute')
const fs = require('fs')
const node_id = "20sez54hq8"
const local_repository = __dirname + "/local_repository/"
const host_url = 'http://127.0.0.1:8080/'
client.on('connect', function () {
    client.subscribe(node_id, function (err) {
        if (!err) {
            console.log("node listening to id", node_id);
            
        }
    })
})

client.on('message', function (topic, message) {
    // message is Buffer
    
    message = JSON.parse(message)
    if (message.type !== 'heartbeat') {
        let runtime = message.runtime
        let functionHash = message.functionHash
        let function_id = message.function_id
        
        if (message.type === "execute") {
            console.log("function_id", function_id);
            if (!fs.existsSync(local_repository + functionHash)) {
                libSupport.download(host_url + functionHash, local_repository + functionHash).then(() => {
                    if (runtime === "isolate")
                        execute.runIsolate(local_repository + functionHash).then(result => {
                            client.publish("response", JSON.stringify({
                                status: "success",
                                result,
                                function_id
                            }))
                        })
                    else if (runtime === "process")
                        execute.runProcess(local_repository + functionHash).then(result => {
                            client.publish("response", JSON.stringify({
                                status: "success",
                                result,
                                function_id
                            }))
                        })
                    else if (runtime === "container")
                        execute.runContainer(functionHash).then(result => {
                            client.publish("response", JSON.stringify({
                                status: "success",
                                result,
                                function_id
                            }))
                        })
                    else {
                        client.publish("response", JSON.stringify({ status: "unknown runtime" }))
                        return
                    }
                })
            } else {
                console.log("in else", local_repository + functionHash);
                
                if (runtime === "isolate")
                    execute.runIsolate(local_repository + functionHash).then(result => {
                        client.publish("response", JSON.stringify({
                            status: "success",
                            result,
                            function_id
                        }))
                    })
                else if (runtime === "process")
                    execute.runProcess(local_repository + functionHash).then(result => {
                        client.publish("response", JSON.stringify({
                            status: "success",
                            result,
                            function_id
                        }))
                    })
                else if (runtime === "container")
                    execute.runContainer(functionHash).then(result => {
                        client.publish("response", JSON.stringify({
                            status: "success",
                            result,
                            function_id
                        }))
                    })
                else {
                    client.publish("response", JSON.stringify({ status: "unknown runtime" }))
                    return
                }
            }
            
        }
    }
        
})

function heartbeat() {
    client.publish(node_id, JSON.stringify({"type": "heartbeat"}))
}

setInterval(heartbeat, 10000);