/*
 * Creator: Naman Dixit
 * Notice: © Copyright 2020 Naman Dixit
 */

internal_function
U64 timeMilli (void)
{
    struct timespec now = {0};

    U64 nanosec = 0;

    if (clock_gettime(CLOCK_MONOTONIC_RAW, &now) == 0) {
        nanosec = ((U64)now.tv_sec * 1000000000ULL) + (U64)now.tv_nsec;
    } else {
        struct timeval now_low = {0};
        gettimeofday(&now_low, NULL);
        nanosec = ((U64)now_low.tv_sec * 1000000000ULL) + (U64)(now_low.tv_usec * 100);
    }

    U64 millisec = nanosec / 1000000ULL;

    return millisec;
}
