/*
 * Creator: Naman Dixit
 * Notice: © Copyright 2020 Naman Dixit
 */

typedef struct Configuration {
    Char *kafka_address;

    U64 heartbeat_gap;
    Sint message_read_gap;
} Configuration;

# if defined(COMPILER_CLANG)
#  pragma clang diagnostic push
#   pragma clang diagnostic ignored "-Wincompatible-pointer-types-discards-qualifiers"
# endif

internal_function
Sint confCallback (void* user, const Char *section,
                   const Char *name, const Char *value)
{
    Configuration* conf = (Configuration*)user;

    if (strequal(section, "Grunt")) {
        if (strequal(name, "MessageReadGap")) {
            conf->message_read_gap = atoi(value);
        } else if (strequal(name, "HeartbeatGap")) {
            conf->heartbeat_gap = strtoul(value, NULL, 10);
        } else {
            return 0;  /* unknown section/name, error */
        }
    } else if (strequal(section, "Kafka")) {
        if (strequal(name, "Address")) {
            conf->kafka_address = strdup(value);
        } else {
            return 0;  /* unknown section/name, error */
        }
    }

    return 1;
}

# if defined(COMPILER_CLANG)
#  pragma clang diagnostic pop
# endif
